/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.steps.DependencyInjector;
import net.thucydides.core.steps.PageObjectDependencyInjector;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.di.DependencyInjectorService;
import net.thucydides.core.webdriver.ThucydidesWebDriverSupport;
import net.thucydides.jbehave.ClassFinder;
import net.thucydides.jbehave.ThucydidesCandidateSteps;
import net.thucydides.jbehave.ThucydidesStepContext;
import org.jbehave.core.configuration.Configuration;
import org.jbehave.core.steps.AbstractStepsFactory;
import org.jbehave.core.steps.CandidateSteps;
import org.jbehave.core.steps.InjectableStepsFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThucydidesStepFactory
extends AbstractStepsFactory {
    private static final ThreadLocal<ThucydidesStepContext> context = new ThreadLocal();
    private final String rootPackage;
    private ClassLoader classLoader;
    private DependencyInjectorService dependencyInjectorService;

    public ThucydidesStepFactory(Configuration configuration, String rootPackage, ClassLoader classLoader) {
        super(configuration);
        this.rootPackage = rootPackage;
        this.classLoader = classLoader;
        this.dependencyInjectorService = (DependencyInjectorService)Injectors.getInjector().getInstance(DependencyInjectorService.class);
    }

    private StepFactory getStepFactory() {
        return ThucydidesWebDriverSupport.getStepFactory().thatThrowsExcpetionsImmediately();
    }

    public List<CandidateSteps> createCandidateSteps() {
        List coreCandidateSteps = super.createCandidateSteps();
        return Lambda.convert((Object)coreCandidateSteps, this.toThucydidesCandidateSteps());
    }

    protected List<Class<?>> stepsTypes() {
        ArrayList types = new ArrayList();
        for (Class candidateClass : this.getCandidateClasses()) {
            if (!this.hasAnnotatedMethods(candidateClass)) continue;
            types.add(candidateClass);
        }
        return types;
    }

    private List<Class> getCandidateClasses() {
        List<Class<?>> allClassesUnderRootPackage = ClassFinder.loadClasses().withClassLoader(this.classLoader).fromPackage(this.rootPackage);
        ArrayList candidateClasses = Lists.newArrayList();
        for (Class<?> classUnderRootPackage : allClassesUnderRootPackage) {
            if (!this.hasAnnotatedMethods(classUnderRootPackage)) continue;
            candidateClasses.add(classUnderRootPackage);
        }
        return candidateClasses;
    }

    private Converter<CandidateSteps, CandidateSteps> toThucydidesCandidateSteps() {
        return new Converter<CandidateSteps, CandidateSteps>(){

            public CandidateSteps convert(CandidateSteps candidateSteps) {
                return new ThucydidesCandidateSteps(candidateSteps);
            }
        };
    }

    public Object createInstanceOfType(Class<?> type) {
        Object stepsInstance = this.getContext().newInstanceOf(type);
        StepAnnotations.injectScenarioStepsInto((Object)stepsInstance, (StepFactory)this.getStepFactory());
        ThucydidesWebDriverSupport.initializeFieldsIn((Object)stepsInstance);
        this.injectDependencies(stepsInstance);
        return stepsInstance;
    }

    private void injectDependencies(Object stepInstance) {
        List dependencyInjectors = this.dependencyInjectorService.findDependencyInjectors();
        dependencyInjectors.add(new PageObjectDependencyInjector(ThucydidesWebDriverSupport.getPages()));
        for (DependencyInjector injector : dependencyInjectors) {
            injector.injectDependenciesInto(stepInstance);
        }
    }

    public ThucydidesStepContext getContext() {
        if (context.get() == null) {
            context.set(new ThucydidesStepContext());
        }
        return context.get();
    }

    public static void resetContext() {
        context.remove();
    }

    public static ThucydidesStepFactory withStepsFromPackage(String rootPackage, Configuration configuration) {
        return new ThucydidesStepFactory(configuration, rootPackage, ThucydidesStepFactory.defaultClassLoader());
    }

    private static ClassLoader defaultClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public ThucydidesStepFactory andConfiguration(Configuration configuration) {
        return new ThucydidesStepFactory(configuration, this.rootPackage, this.classLoader);
    }

    public InjectableStepsFactory andClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }
}

