/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.base.WallTime;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum Meridiem implements ChronoCondition<WallTime>
{
    AM,
    PM;


    public static Meridiem ofHour(int n) {
        if (n >= 0 && n <= 24) {
            return n < 12 || n == 24 ? AM : PM;
        }
        throw new IllegalArgumentException("Hour of day out of range: " + n);
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return CalendarText.getIsoInstance(locale).getMeridiems(textWidth, outputContext).print(this);
    }

    public static Meridiem parse(CharSequence charSequence, Locale locale, TextWidth textWidth, OutputContext outputContext) throws ParseException {
        char c;
        if (charSequence.length() == 2 && ((c = charSequence.charAt(1)) == 'M' || c == 'm')) {
            char c2 = charSequence.charAt(0);
            if (c2 == 'A' || c2 == 'a') {
                return AM;
            }
            if (c2 == 'P' || c2 == 'p') {
                return PM;
            }
        }
        ParsePosition parsePosition = new ParsePosition(0);
        Meridiem meridiem = CalendarText.getIsoInstance(locale).getMeridiems(textWidth, outputContext).parse(charSequence, parsePosition, Meridiem.class);
        if (meridiem == null) {
            throw new ParseException("Cannot parse: " + charSequence, parsePosition.getErrorIndex());
        }
        return meridiem;
    }

    @Override
    public boolean test(WallTime wallTime) {
        int n = wallTime.getHour();
        return this == AM ? n < 12 || n == 24 : n >= 12 && n < 24;
    }
}

