/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.time.format.FormatStyle;
import java.util.Locale;
import net.time4j.ClockUnit;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.TimeSource;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.service.GenericDatePatterns;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.StartOfDay;
import net.time4j.format.Attributes;
import net.time4j.format.Leniency;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

abstract class AbstractMergerEA<C extends EastAsianCalendar<?, C>>
implements ChronoMerger<C> {
    private final Class<C> chronoType;

    AbstractMergerEA(Class<C> clazz) {
        this.chronoType = clazz;
    }

    @Override
    public String getFormatPattern(FormatStyle formatStyle, Locale locale) {
        return GenericDatePatterns.get("chinese", formatStyle, locale);
    }

    @Override
    public C createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
        TZID tZID;
        if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
            tZID = attributeQuery.get(Attributes.TIMEZONE_ID);
        } else if (attributeQuery.get(Attributes.LENIENCY, Leniency.SMART).isLax()) {
            tZID = Timezone.ofSystem().getID();
        } else {
            return null;
        }
        StartOfDay startOfDay = attributeQuery.get(Attributes.START_OF_DAY, this.getDefaultStartOfDay());
        PlainTimestamp plainTimestamp = Moment.from(timeSource.currentTime()).toZonalTimestamp(tZID);
        int n = startOfDay.getDeviation(plainTimestamp.getCalendarDate(), tZID);
        plainTimestamp = plainTimestamp.minus((long)n, ClockUnit.SECONDS);
        return (C)((EastAsianCalendar)plainTimestamp.getCalendarDate().transform(this.chronoType));
    }

    @Override
    public abstract C createFrom(ChronoEntity<?> var1, AttributeQuery var2, boolean var3, boolean var4);

    @Override
    public ChronoDisplay preformat(C c, AttributeQuery attributeQuery) {
        return c;
    }

    @Override
    public int getDefaultPivotYear() {
        return 100;
    }
}

