/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import net.time4j.SystemClock;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.calendar.AbstractMergerEA;
import net.time4j.calendar.ChineseEra;
import net.time4j.calendar.CommonElements;
import net.time4j.calendar.CyclicYear;
import net.time4j.calendar.EastAsianCS;
import net.time4j.calendar.EastAsianCY;
import net.time4j.calendar.EastAsianCalendar;
import net.time4j.calendar.EastAsianME;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.calendar.EastAsianST;
import net.time4j.calendar.EastAsianYear;
import net.time4j.calendar.OrdinalWeekdayElement;
import net.time4j.calendar.SPXEA;
import net.time4j.calendar.SexagesimalName;
import net.time4j.calendar.SolarTerm;
import net.time4j.calendar.StdCalendarElement;
import net.time4j.calendar.WeekdayInMonthElement;
import net.time4j.calendar.service.RelatedGregorianYearRule;
import net.time4j.calendar.service.StdIntegerDateElement;
import net.time4j.calendar.service.StdWeekdayElement;
import net.time4j.calendar.service.WeekdayRule;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoUnit;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.DisplayElement;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.tz.OffsetSign;
import net.time4j.tz.ZonalOffset;

@CalendarType(value="chinese")
public final class ChineseCalendar
extends EastAsianCalendar<Unit, ChineseCalendar>
implements LocalizedPatternSupport {
    private static final int[] LEAP_MONTHS = new int[]{4281, 5, 4284, 4, 4287, 1, 4289, 6, 4292, 5, 4295, 3, 4297, 8, 4300, 6, 4303, 4, 4306, 2, 4308, 7, 4311, 5, 4314, 3, 4316, 8, 4319, 6, 4322, 4, 4325, 3, 4327, 7, 4330, 5, 4333, 3, 4335, 7, 4338, 6, 4341, 4, 4344, 3, 4346, 7, 4349, 5, 4352, 3, 4354, 8, 4357, 6, 4360, 4, 4363, 2, 4365, 7, 4368, 5, 4371, 4, 4373, 9, 4376, 6, 4379, 4, 4382, 3, 4384, 7, 4387, 5, 4390, 4, 4392, 9, 4395, 6, 4398, 5, 4401, 2, 4403, 7, 4406, 5, 4409, 3, 4411, 10, 4414, 6, 4417, 5, 4420, 3, 4422, 7, 4425, 5, 4428, 4, 4431, 2, 4433, 6, 4436, 4, 4439, 2, 4441, 7, 4444, 5, 4447, 3, 4450, 2, 4452, 6, 4455, 4, 4458, 3, 4460, 7, 4463, 5, 4466, 4, 4468, 9, 4471, 6, 4474, 4, 4477, 3, 4479, 7, 4482, 5, 4485, 4, 4487, 8, 4490, 7, 4493, 5, 4496, 3, 4498, 8, 4501, 5, 4504, 4, 4506, 10, 4509, 6, 4512, 5, 4515, 3, 4517, 7, 4520, 5, 4523, 4, 4526, 2, 4528, 6, 4531, 5, 4534, 3, 4536, 8, 4539, 5, 4542, 4, 4545, 2, 4547, 6, 4550, 5, 4553, 2, 4555, 7, 4558, 5, 4561, 4, 4564, 2, 4566, 6, 4569, 5, 4572, 3, 4574, 7, 4577, 6, 4580, 4, 4583, 2, 4585, 7, 4588, 5, 4591, 3, 4593, 8, 4596, 6, 4599, 4, 4602, 3, 4604, 7, 4607, 5, 4610, 4, 4612, 8, 4615, 6, 4618, 4, 4620, 10, 4623, 6, 4626, 5, 4629, 3, 4631, 8, 4634, 5, 4637, 4, 4640, 2, 4642, 7, 4645, 5, 4648, 4, 4650, 9, 4653, 6, 4656, 4, 4659, 2, 4661, 6, 4664, 5, 4667, 3, 4669, 11, 4672, 6, 4675, 5, 4678, 2, 4680, 7, 4683, 5, 4686, 3, 4688, 8, 4691, 6, 4694, 4, 4697, 3, 4699, 7, 4702, 5, 4705, 4, 4707, 8, 4710, 6, 4713, 4, 4716, 3, 4718, 7, 4721, 5, 4724, 4, 4726, 8, 4729, 6, 4732, 4, 4735, 2, 4737, 7, 4740, 5, 4743, 4, 4745, 9, 4748, 6, 4751, 4, 4754, 3, 4756, 7, 4759, 5, 4762, 4, 4764, 11, 4767, 6, 4770, 5, 4773, 2, 4775, 7, 4778, 5, 4781, 4, 4783, 11, 4786, 6, 4789, 5, 4792, 3, 4794, 7, 4797, 6, 4800, 4, 4802, 10, 4805, 6, 4808, 5, 4811, 3, 4813, 7, 4816, 6, 4819, 4, 4822, 2, 4824, 6, 4827, 5, 4830, 3, 4832, 7, 4835, 6, 4838, 4, 4840, 9, 4843, 6, 4846, 4, 4849, 3, 4851, 7, 4854, 5, 4857, 4, 4859, 9, 4862, 7, 4865, 5, 4868, 3, 4870, 8, 4873, 5, 4876, 4, 4878, 11, 4881, 6, 4884, 5, 4887, 3, 4889, 7, 4892, 6, 4895, 5, 4898, 1, 4900, 7, 4903, 5, 4906, 3, 4908, 8, 4911, 6, 4914, 4, 4917, 2, 4919, 6, 4922, 5, 4925, 3, 4927, 7, 4930, 6, 4933, 4, 4936, 2, 4938, 6, 4941, 5, 4944, 3, 4946, 7, 4949, 6, 4952, 4, 4954, 10, 4957, 7, 4960, 5, 4963, 3, 4965, 8, 4968, 6, 4971, 4, 4974, 3, 4976, 7, 4979, 5, 4982, 4, 4984, 8, 4987, 6, 4990, 5, 4993, 1, 4995, 7, 4998, 5, 5001, 4, 5003, 8, 5006, 6, 5009, 5, 5012, 2, 5014, 7, 5017, 5, 5020, 4, 5022, 10, 5025, 6, 5028, 4, 5031, 2, 5033, 6, 5036, 5, 5039, 3, 5041, 8, 5044, 6, 5047, 5, 5050, 2, 5052, 7, 5055, 5, 5058, 3, 5060, 8, 5063, 6, 5066, 4, 5069, 3, 5071, 7, 5074, 5, 5077, 4, 5079, 8, 5082, 7, 5085, 5, 5088, 3, 5090, 8, 5093, 5, 5096, 4, 5098, 8, 5101, 6, 5104, 5, 5107, 3, 5109, 7, 5112, 5, 5115, 4, 5117, 10, 5120, 6, 5123, 5, 5126, 3, 5128, 7, 5131, 5, 5134, 4, 5136, 10, 5139, 6, 5142, 5, 5145, 2, 5147, 7, 5150, 5, 5153, 4, 5156, 1, 5158, 6, 5161, 5, 5164, 3, 5166, 7, 5169, 6, 5172, 4, 5175, 1, 5177, 7, 5180, 5, 5183, 3, 5185, 7, 5188, 6, 5191, 4, 5193, 8, 5196, 7, 5199, 5, 5202, 4, 5204, 7, 5207, 6, 5210, 4, 5212, 9, 5215, 7, 5218, 5, 5221, 3, 5223, 7, 5226, 6, 5229, 4, 5231, 10, 5234, 7, 5237, 5, 5240, 3, 5242, 8, 5245, 6, 5248, 4, 5250, 11, 5253, 6, 5256, 5, 5259, 3, 5261, 8, 5264, 6, 5267, 5, 5270, 1, 5272, 7, 5275, 5, 5278, 3, 5280, 8, 5283, 6, 5286, 4, 5289, 2, 5291, 7, 5294, 5, 5297, 3, 5299, 7, 5302, 6, 5305, 4, 5308, 3, 5310, 7, 5313, 5, 5316, 3, 5318, 7, 5321, 6, 5324, 4, 5327, 3, 5329, 7, 5332, 5, 5335, 3, 5337, 8, 5340, 6, 5343, 4, 5346, 2, 5348, 7, 5351, 5, 5354, 4, 5356, 9, 5359, 6, 5362, 5, 5364, 11, 5367, 7, 5370, 5, 5373, 4, 5375, 9, 5378, 6, 5381, 5, 5384, 2, 5386, 7, 5389, 6, 5392, 4, 5394, 8, 5397, 6, 5400, 5, 5403, 3, 5405, 7, 5408, 6, 5411, 4, 5413, 8, 5416, 6, 5419, 5, 5422, 3, 5424, 7, 5427, 6, 5430, 3, 5432, 8, 5435, 6, 5438, 4, 5441, 3, 5443, 7, 5446, 6, 5449, 4, 5451, 9, 5454, 7, 5457, 5, 5460, 3, 5462, 8, 5465, 5, 5468, 4, 5470, 9, 5473, 6, 5476, 5, 5479, 3, 5481, 8, 5484, 6, 5487, 4, 5489, 9, 5492, 6, 5495, 5, 5498, 3, 5500, 7, 5503, 6, 5506, 4, 5508, 10, 5511, 6, 5514, 5, 5517, 3, 5519, 7, 5522, 6, 5525, 4, 5527, 10, 5530, 6, 5533, 5, 5536, 3, 5538, 7, 5541, 6, 5544, 4, 5546, 11, 5549, 7, 5552, 5, 5555, 3, 5557, 8, 5560, 6, 5563, 4, 5565, 9, 5568, 7, 5571, 5, 5574, 4, 5576, 8, 5579, 6, 5582, 4, 5584, 8, 5587, 7, 5590, 5, 5593, 4, 5595, 8, 5598, 6, 5601, 5, 5603, 10, 5606, 7, 5609, 5, 5612, 3, 5614, 8, 5617, 6, 5620, 4, 5622, 10, 5625, 6, 5628, 5, 5631, 3, 5633, 8, 5636, 6};
    @FormattableElement(format="G")
    public static final ChronoElement<ChineseEra> ERA = EraElement.INSTANCE;
    public static final ChronoElement<Integer> CYCLE = new StdIntegerDateElement<ChineseCalendar>("CYCLE", ChineseCalendar.class, 72, 94, '\u0000');
    @FormattableElement(format="y")
    public static final StdCalendarElement<Integer, ChineseCalendar> YEAR_OF_ERA = new StdIntegerDateElement<ChineseCalendar>("YEAR_OF_ERA", ChineseCalendar.class, 1, 5636, 'y');
    @FormattableElement(format="U")
    public static final TextElement<CyclicYear> YEAR_OF_CYCLE = EastAsianCY.SINGLETON;
    public static final ChronoElement<SolarTerm> SOLAR_TERM = EastAsianST.getInstance();
    @FormattableElement(format="M", alt="L")
    public static final TextElement<EastAsianMonth> MONTH_OF_YEAR = EastAsianME.SINGLETON_EA;
    public static final StdCalendarElement<Integer, ChineseCalendar> MONTH_AS_ORDINAL = new StdIntegerDateElement<ChineseCalendar>("MONTH_AS_ORDINAL", ChineseCalendar.class, 1, 12, '\u0000');
    @FormattableElement(format="d")
    public static final StdCalendarElement<Integer, ChineseCalendar> DAY_OF_MONTH = new StdIntegerDateElement<ChineseCalendar>("DAY_OF_MONTH", ChineseCalendar.class, 1, 30, 'd');
    @FormattableElement(format="D")
    public static final StdCalendarElement<Integer, ChineseCalendar> DAY_OF_YEAR = new StdIntegerDateElement<ChineseCalendar>("DAY_OF_YEAR", ChineseCalendar.class, 1, 355, 'D');
    @FormattableElement(format="E")
    public static final StdCalendarElement<Weekday, ChineseCalendar> DAY_OF_WEEK = new StdWeekdayElement<ChineseCalendar>(ChineseCalendar.class, ChineseCalendar.getDefaultWeekmodel());
    private static final WeekdayInMonthElement<ChineseCalendar> WIM_ELEMENT = new WeekdayInMonthElement<ChineseCalendar>(ChineseCalendar.class, DAY_OF_MONTH, DAY_OF_WEEK);
    @FormattableElement(format="F")
    public static final OrdinalWeekdayElement<ChineseCalendar> WEEKDAY_IN_MONTH = WIM_ELEMENT;
    private static final EastAsianCS<ChineseCalendar> CALSYS = new Transformer();
    private static final TimeAxis<Unit, ChineseCalendar> ENGINE;
    private static final long serialVersionUID = 8743381746750717307L;

    private ChineseCalendar(int n, int n2, EastAsianMonth eastAsianMonth, int n3, long l) {
        super(n, n2, eastAsianMonth, n3, l);
    }

    public static ChineseCalendar ofNewYear(int n) {
        return ChineseCalendar.of(EastAsianYear.forGregorian(n), EastAsianMonth.valueOf(1), 1);
    }

    public static ChineseCalendar ofQingMing(int n) {
        ChineseCalendar chineseCalendar = ChineseCalendar.ofNewYear(n);
        return (ChineseCalendar)chineseCalendar.with(SolarTerm.MINOR_03_QINGMING_015.sinceLichun());
    }

    public static ChineseCalendar of(EastAsianYear eastAsianYear, EastAsianMonth eastAsianMonth, int n) {
        int n2 = eastAsianYear.getCycle();
        int n3 = eastAsianYear.getYearOfCycle().getNumber();
        return ChineseCalendar.of(n2, n3, eastAsianMonth, n);
    }

    public static ChineseCalendar nowInSystemTime() {
        return (ChineseCalendar)SystemClock.inLocalView().now(ChineseCalendar.axis());
    }

    public static boolean isValid(EastAsianYear eastAsianYear, EastAsianMonth eastAsianMonth, int n) {
        int n2 = eastAsianYear.getCycle();
        int n3 = eastAsianYear.getYearOfCycle().getNumber();
        return CALSYS.isValid(n2, n3, eastAsianMonth, n);
    }

    public static Weekmodel getDefaultWeekmodel() {
        return Weekmodel.of(Locale.CHINA);
    }

    public static TimeAxis<Unit, ChineseCalendar> axis() {
        return ENGINE;
    }

    @Override
    protected TimeAxis<Unit, ChineseCalendar> getChronology() {
        return ENGINE;
    }

    @Override
    protected ChineseCalendar getContext() {
        return this;
    }

    @Override
    EastAsianCS<ChineseCalendar> getCalendarSystem() {
        return CALSYS;
    }

    static ChineseCalendar of(int n, int n2, EastAsianMonth eastAsianMonth, int n3) {
        long l = CALSYS.transform(n, n2, eastAsianMonth, n3);
        return new ChineseCalendar(n, n2, eastAsianMonth, n3, l);
    }

    private Object writeReplace() {
        return new SPXEA(this, 14);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Chronology.Builder builder = ((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)((TimeAxis.Builder)TimeAxis.Builder.setUp(Unit.class, ChineseCalendar.class, new Merger(), CALSYS).appendElement((ChronoElement)ERA, (ElementRule)EraElement.INSTANCE)).appendElement((ChronoElement)CYCLE, EastAsianCalendar.getCycleRule(YEAR_OF_CYCLE))).appendElement((ChronoElement)YEAR_OF_ERA, (ElementRule)new YearOfEraRule())).appendElement(YEAR_OF_CYCLE, EastAsianCalendar.getYearOfCycleRule(MONTH_OF_YEAR), Unit.YEARS).appendElement((ChronoElement)SOLAR_TERM, (ElementRule)EastAsianST.getInstance())).appendElement(MONTH_OF_YEAR, EastAsianCalendar.getMonthOfYearRule(DAY_OF_MONTH), Unit.MONTHS).appendElement(MONTH_AS_ORDINAL, EastAsianCalendar.getMonthAsOrdinalRule(DAY_OF_MONTH), Unit.MONTHS).appendElement(DAY_OF_MONTH, EastAsianCalendar.getDayOfMonthRule(), Unit.DAYS).appendElement(DAY_OF_YEAR, EastAsianCalendar.getDayOfYearRule(), Unit.DAYS).appendElement(DAY_OF_WEEK, new WeekdayRule<ChineseCalendar>(ChineseCalendar.getDefaultWeekmodel(), chineseCalendar -> CALSYS), Unit.DAYS).appendElement(WIM_ELEMENT, (ElementRule)WeekdayInMonthElement.getRule(WIM_ELEMENT))).appendElement((ChronoElement)CommonElements.RELATED_GREGORIAN_YEAR, new RelatedGregorianYearRule<ChineseCalendar>(CALSYS, DAY_OF_YEAR))).appendUnit(Unit.CYCLES, EastAsianCalendar.getUnitRule(0), Unit.CYCLES.getLength(), Collections.singleton(Unit.YEARS)).appendUnit(Unit.YEARS, EastAsianCalendar.getUnitRule(1), Unit.YEARS.getLength(), Collections.singleton(Unit.CYCLES)).appendUnit(Unit.MONTHS, EastAsianCalendar.getUnitRule(2), Unit.MONTHS.getLength(), Collections.emptySet()).appendUnit(Unit.WEEKS, EastAsianCalendar.getUnitRule(3), Unit.WEEKS.getLength(), Collections.singleton(Unit.DAYS)).appendUnit(Unit.DAYS, EastAsianCalendar.getUnitRule(4), Unit.DAYS.getLength(), Collections.singleton(Unit.WEEKS)).appendExtension(new CommonElements.Weekengine(ChineseCalendar.class, DAY_OF_MONTH, DAY_OF_YEAR, ChineseCalendar.getDefaultWeekmodel()));
        ENGINE = ((TimeAxis.Builder)builder).build();
    }

    private static class EraElement
    extends DisplayElement<ChineseEra>
    implements TextElement<ChineseEra>,
    ElementRule<ChineseCalendar, ChineseEra> {
        static final EraElement INSTANCE = new EraElement();
        private static final long serialVersionUID = -7868534502157983978L;

        private EraElement() {
            super("ERA");
        }

        @Override
        public Class<ChineseEra> getType() {
            return ChineseEra.class;
        }

        @Override
        public char getSymbol() {
            return 'G';
        }

        @Override
        public ChineseEra getDefaultMinimum() {
            return ChineseEra.QING_SHUNZHI_1644_1662;
        }

        @Override
        public ChineseEra getDefaultMaximum() {
            return ChineseEra.YELLOW_EMPEROR;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public ChineseEra getValue(ChineseCalendar chineseCalendar) {
            int n = this.getRelatedGregorianYear(chineseCalendar);
            if (n < 1662) {
                return ChineseEra.QING_SHUNZHI_1644_1662;
            }
            if (n < 1723) {
                return ChineseEra.QING_KANGXI_1662_1723;
            }
            if (n < 1736) {
                return ChineseEra.QING_YONGZHENG_1723_1736;
            }
            if (n < 1796) {
                return ChineseEra.QING_QIANLONG_1736_1796;
            }
            if (n < 1821) {
                return ChineseEra.QING_JIAQING_1796_1821;
            }
            if (n < 1851) {
                return ChineseEra.QING_DAOGUANG_1821_1851;
            }
            if (n < 1862) {
                return ChineseEra.QING_XIANFENG_1851_1862;
            }
            if (n < 1875) {
                return ChineseEra.QING_TONGZHI_1862_1875;
            }
            if (n < 1909) {
                return ChineseEra.QING_GUANGXU_1875_1909;
            }
            if (chineseCalendar.getDaysSinceEpochUTC() < -21873L) {
                return ChineseEra.QING_XUANTONG_1909_1912;
            }
            return ChineseEra.YELLOW_EMPEROR;
        }

        @Override
        public ChineseEra getMinimum(ChineseCalendar chineseCalendar) {
            return ChineseEra.QING_SHUNZHI_1644_1662;
        }

        @Override
        public ChineseEra getMaximum(ChineseCalendar chineseCalendar) {
            return ChineseEra.YELLOW_EMPEROR;
        }

        @Override
        public boolean isValid(ChineseCalendar chineseCalendar, ChineseEra chineseEra) {
            return this.getValue(chineseCalendar) == chineseEra;
        }

        @Override
        public ChineseCalendar withValue(ChineseCalendar chineseCalendar, ChineseEra chineseEra, boolean bl) {
            if (this.isValid(chineseCalendar, chineseEra)) {
                return chineseCalendar;
            }
            if (chineseEra == null) {
                throw new IllegalArgumentException("Missing Chinese era.");
            }
            throw new IllegalArgumentException("Chinese era is read-only.");
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ChineseCalendar chineseCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ChineseCalendar chineseCalendar) {
            return YEAR_OF_ERA;
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            String string = chronoDisplay.get(this).getDisplayName(locale, textWidth);
            appendable.append(string);
        }

        @Override
        public ChineseEra parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            String string;
            int n;
            String string2;
            Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            int n2 = parsePosition.getIndex();
            for (ChineseEra chineseEra : ChineseEra.values()) {
                string2 = chineseEra.getDisplayName(locale, textWidth);
                n = Math.max(Math.min(n2 + string2.length(), charSequence.length()), n2);
                if (n <= n2) continue;
                string = charSequence.subSequence(n2, n).toString();
                if (bl) {
                    string2 = string2.toLowerCase(locale);
                    string = string.toLowerCase(locale);
                }
                if (!string2.equals(string) && (!bl2 || !string2.startsWith(string))) continue;
                parsePosition.setIndex(n);
                return chineseEra;
            }
            if (!locale.getLanguage().isEmpty() && !locale.getLanguage().equals("zh")) {
                for (ChineseEra chineseEra : ChineseEra.values()) {
                    string2 = chineseEra.getDisplayName(Locale.ROOT, textWidth);
                    n = Math.max(Math.min(n2 + string2.length(), charSequence.length()), n2);
                    if (n <= n2) continue;
                    string = charSequence.subSequence(n2, n).toString();
                    if (bl) {
                        string2 = string2.toLowerCase(Locale.ROOT);
                        string = string.toLowerCase(Locale.ROOT);
                    }
                    if (!string2.equals(string) && (!bl2 || !string2.startsWith(string))) continue;
                    parsePosition.setIndex(n);
                    return chineseEra;
                }
            }
            parsePosition.setErrorIndex(n2);
            return null;
        }

        @Override
        protected boolean isSingleton() {
            return true;
        }

        private Object readResolve() throws ObjectStreamException {
            return INSTANCE;
        }

        private int getRelatedGregorianYear(ChineseCalendar chineseCalendar) {
            int n = chineseCalendar.getCycle();
            int n2 = chineseCalendar.getYear().getNumber();
            return (n - 1) * 60 + n2 - 2637;
        }
    }

    private static class Transformer
    extends EastAsianCS<ChineseCalendar> {
        private static final ZonalOffset OFFSET_OLD_CHINA = ZonalOffset.atLongitude(OffsetSign.AHEAD_OF_UTC, 116, 25, 0.0);
        private static final ZonalOffset OFFSET_NEW_CHINA = ZonalOffset.ofHours(OffsetSign.AHEAD_OF_UTC, 8);
        private static final long OFFSET_SWITCH_CHINA = -15705L;

        private Transformer() {
        }

        @Override
        public List<CalendarEra> getEras() {
            return Arrays.asList(ChineseEra.values());
        }

        @Override
        ChineseCalendar create(int n, int n2, EastAsianMonth eastAsianMonth, int n3, long l) {
            return new ChineseCalendar(n, n2, eastAsianMonth, n3, l);
        }

        @Override
        ZonalOffset getOffset(long l) {
            return l < -15705L ? OFFSET_OLD_CHINA : OFFSET_NEW_CHINA;
        }

        @Override
        int[] getLeapMonths() {
            return LEAP_MONTHS;
        }
    }

    public static enum Unit implements ChronoUnit
    {
        CYCLES(1.893415507776E9),
        YEARS(3.15569251296E7),
        MONTHS(2551442.8775903997),
        WEEKS(604800.0),
        DAYS(86400.0);

        private final transient double length;

        private Unit(double d) {
            this.length = d;
        }

        @Override
        public double getLength() {
            return this.length;
        }

        @Override
        public boolean isCalendrical() {
            return true;
        }

        public int between(ChineseCalendar chineseCalendar, ChineseCalendar chineseCalendar2) {
            return (int)chineseCalendar.until(chineseCalendar2, this);
        }
    }

    private static class Merger
    extends AbstractMergerEA<ChineseCalendar> {
        Merger() {
            super(ChineseCalendar.class);
        }

        @Override
        public ChineseCalendar createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n;
            Comparable<SexagesimalName> comparable;
            EastAsianYear eastAsianYear = null;
            int n2 = chronoEntity.getInt(CommonElements.RELATED_GREGORIAN_YEAR);
            if (n2 == Integer.MIN_VALUE) {
                int n3;
                if (chronoEntity.contains(YEAR_OF_CYCLE)) {
                    comparable = chronoEntity.get(YEAR_OF_CYCLE);
                    n = chronoEntity.getInt(CYCLE);
                    if (n == Integer.MIN_VALUE) {
                        ChineseEra chineseEra;
                        if (chronoEntity.contains(ERA) && (chineseEra = chronoEntity.get(ERA)).isQingDynasty()) {
                            eastAsianYear = ((CyclicYear)comparable).inQingDynasty(chineseEra);
                        }
                    } else {
                        eastAsianYear = ((CyclicYear)comparable).inCycle(n);
                    }
                } else if (chronoEntity.contains(ERA) && (n3 = chronoEntity.getInt(YEAR_OF_ERA)) != Integer.MIN_VALUE) {
                    ChineseEra chineseEra = chronoEntity.get(ERA);
                    eastAsianYear = EastAsianYear.forGregorian(chineseEra.getStartAsGregorianYear() + n3 - 1);
                }
            } else {
                eastAsianYear = EastAsianYear.forGregorian(n2);
            }
            if (eastAsianYear == null) {
                chronoEntity.with(ValidationElement.ERROR_MESSAGE, "Cannot determine East Asian year.");
                return null;
            }
            if (chronoEntity.contains(MONTH_OF_YEAR)) {
                comparable = chronoEntity.get(MONTH_OF_YEAR);
                n = chronoEntity.getInt(DAY_OF_MONTH);
                if (n != Integer.MIN_VALUE) {
                    return ChineseCalendar.of(eastAsianYear, comparable, n);
                }
            } else {
                int n4 = chronoEntity.getInt(DAY_OF_YEAR);
                if (n4 != Integer.MIN_VALUE && n4 >= 1) {
                    ChineseCalendar chineseCalendar = ChineseCalendar.of(eastAsianYear, EastAsianMonth.valueOf(1), 1);
                    return (ChineseCalendar)chineseCalendar.plus(n4 - 1, Unit.DAYS);
                }
            }
            return null;
        }
    }

    private static class YearOfEraRule
    implements IntElementRule<ChineseCalendar> {
        private YearOfEraRule() {
        }

        @Override
        public Integer getValue(ChineseCalendar chineseCalendar) {
            return this.getInt(chineseCalendar);
        }

        @Override
        public Integer getMinimum(ChineseCalendar chineseCalendar) {
            ChineseEra chineseEra = chineseCalendar.get(ERA);
            return chineseEra.getMinYearOfEra();
        }

        @Override
        public Integer getMaximum(ChineseCalendar chineseCalendar) {
            ChineseEra chineseEra = chineseCalendar.get(ERA);
            return chineseEra.getMaxYearOfEra();
        }

        @Override
        public boolean isValid(ChineseCalendar chineseCalendar, Integer n) {
            return n != null && this.isValid(chineseCalendar, (int)n);
        }

        @Override
        public ChineseCalendar withValue(ChineseCalendar chineseCalendar, Integer n, boolean bl) {
            if (n == null) {
                throw new IllegalArgumentException("Missing year of era.");
            }
            return this.withValue(chineseCalendar, (int)n, bl);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(ChineseCalendar chineseCalendar) {
            return MONTH_OF_YEAR;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(ChineseCalendar chineseCalendar) {
            return MONTH_OF_YEAR;
        }

        @Override
        public int getInt(ChineseCalendar chineseCalendar) {
            int n = EraElement.INSTANCE.getRelatedGregorianYear(chineseCalendar);
            if (n < 1662) {
                return n - 1644 + 1;
            }
            if (n < 1723) {
                return n - 1662 + 1;
            }
            if (n < 1736) {
                return n - 1723 + 1;
            }
            if (n < 1796) {
                return n - 1736 + 1;
            }
            if (n < 1821) {
                return n - 1796 + 1;
            }
            if (n < 1851) {
                return n - 1821 + 1;
            }
            if (n < 1862) {
                return n - 1851 + 1;
            }
            if (n < 1875) {
                return n - 1862 + 1;
            }
            if (n < 1909) {
                return n - 1875 + 1;
            }
            if (chineseCalendar.getDaysSinceEpochUTC() < -21873L) {
                return n - 1909 + 1;
            }
            return n + 2637 + 61;
        }

        @Override
        public boolean isValid(ChineseCalendar chineseCalendar, int n) {
            ChineseEra chineseEra = chineseCalendar.get(ERA);
            return n >= chineseEra.getMinYearOfEra() && n <= chineseEra.getMaxYearOfEra();
        }

        @Override
        public ChineseCalendar withValue(ChineseCalendar chineseCalendar, int n, boolean bl) {
            if (this.isValid(chineseCalendar, n)) {
                int n2 = this.getInt(chineseCalendar);
                return (ChineseCalendar)chineseCalendar.plus(n - n2, Unit.YEARS);
            }
            throw new IllegalArgumentException("Invalid year of era: " + n);
        }
    }
}

