/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.InvalidObjectException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import net.time4j.calendar.HebrewCalendar;
import net.time4j.calendar.HebrewMonth;
import net.time4j.calendar.HebrewTime;

final class SPXHebrew
implements Externalizable {
    static final int DATE = 12;
    static final int TIME = 13;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPXHebrew() {
    }

    SPXHebrew(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeByte(this.type);
        switch (this.type) {
            case 12: {
                HebrewCalendar hebrewCalendar = (HebrewCalendar)this.obj;
                objectOutput.writeInt(hebrewCalendar.getYear());
                objectOutput.writeByte(hebrewCalendar.getMonth().getValue());
                objectOutput.writeByte(hebrewCalendar.getDayOfMonth());
                break;
            }
            case 13: {
                HebrewTime hebrewTime = (HebrewTime)this.obj;
                objectOutput.writeByte(hebrewTime.getDigitalHour());
                objectOutput.writeShort(hebrewTime.getPart());
                break;
            }
            default: {
                throw new InvalidClassException("Unsupported calendar type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by) {
            case 12: {
                int n = objectInput.readInt();
                HebrewMonth hebrewMonth = HebrewMonth.valueOf(objectInput.readByte());
                byte by2 = objectInput.readByte();
                this.obj = HebrewCalendar.of(n, hebrewMonth, by2);
                break;
            }
            case 13: {
                byte by3 = objectInput.readByte();
                short s = objectInput.readShort();
                this.obj = HebrewTime.ofDigital(by3, s);
                break;
            }
            default: {
                throw new InvalidObjectException("Unknown calendar type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }
}

