/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.threeten;

import java.io.Serializable;
import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.ZoneId;
import java.time.zone.ZoneOffsetTransition;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;
import java.time.zone.ZoneRulesProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.time4j.Month;
import net.time4j.PlainTime;
import net.time4j.TemporalType;
import net.time4j.Weekday;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;
import net.time4j.tz.ZoneModelProvider;
import net.time4j.tz.model.DaylightSavingRule;
import net.time4j.tz.model.GregorianTimezoneRule;
import net.time4j.tz.model.OffsetIndicator;
import net.time4j.tz.model.TransitionModel;
import net.time4j.tz.threeten.NegativeDayOfMonthPattern;

public class JdkZoneProviderSPI
implements ZoneModelProvider {
    private final String version = ZoneRulesProvider.getVersions("America/New_York").lastEntry().getKey();

    @Override
    public Set<String> getAvailableIDs() {
        return Collections.unmodifiableSet(ZoneRulesProvider.getAvailableZoneIds());
    }

    @Override
    public Map<String, String> getAliases() {
        return Collections.emptyMap();
    }

    @Override
    public String getFallback() {
        return "";
    }

    @Override
    public String getName() {
        return "TZDB";
    }

    @Override
    public String getLocation() {
        return "{java.home}/lib/tzdb.dat";
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public TransitionHistory load(String string) {
        try {
            return JdkZoneProviderSPI.load(ZoneId.of(string));
        }
        catch (DateTimeException dateTimeException) {
            throw new IllegalArgumentException(dateTimeException);
        }
    }

    public static TransitionHistory load(ZoneId zoneId) {
        try {
            Serializable serializable;
            ZoneRules zoneRules = zoneId.getRules();
            ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds(zoneRules.getOffset(Instant.MIN).getTotalSeconds());
            ArrayList<ZonalTransition> arrayList = new ArrayList<ZonalTransition>();
            ArrayList<DaylightSavingRule> arrayList2 = new ArrayList<DaylightSavingRule>();
            for (ZoneOffsetTransition serializable2 : zoneRules.getTransitions()) {
                serializable = serializable2.getInstant();
                long l = serializable.getEpochSecond();
                int n = serializable2.getOffsetBefore().getTotalSeconds();
                int n2 = serializable2.getOffsetAfter().getTotalSeconds();
                int n3 = Math.toIntExact(zoneRules.getDaylightSavings((Instant)serializable).getSeconds());
                arrayList.add(new ZonalTransition(l, n, n2, n3));
            }
            for (ZoneOffsetTransitionRule zoneOffsetTransitionRule : zoneRules.getTransitionRules()) {
                OffsetIndicator offsetIndicator;
                int n = zoneOffsetTransitionRule.getDayOfMonthIndicator();
                DayOfWeek dayOfWeek = zoneOffsetTransitionRule.getDayOfWeek();
                Month month = Month.valueOf(zoneOffsetTransitionRule.getMonth().getValue());
                PlainTime plainTime = zoneOffsetTransitionRule.isMidnightEndOfDay() ? PlainTime.midnightAtEndOfDay() : TemporalType.LOCAL_TIME.translate(zoneOffsetTransitionRule.getLocalTime());
                switch (zoneOffsetTransitionRule.getTimeDefinition()) {
                    case STANDARD: {
                        offsetIndicator = OffsetIndicator.STANDARD_TIME;
                        break;
                    }
                    case UTC: {
                        offsetIndicator = OffsetIndicator.UTC_TIME;
                        break;
                    }
                    case WALL: {
                        offsetIndicator = OffsetIndicator.WALL_TIME;
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(zoneOffsetTransitionRule.getTimeDefinition().name());
                    }
                }
                int n4 = zoneOffsetTransitionRule.getOffsetAfter().getTotalSeconds() - zoneOffsetTransitionRule.getStandardOffset().getTotalSeconds();
                if (dayOfWeek == null) {
                    serializable = GregorianTimezoneRule.ofFixedDay(month, n, plainTime, offsetIndicator, n4);
                } else {
                    Weekday weekday = Weekday.valueOf(dayOfWeek.getValue());
                    serializable = n == -1 ? GregorianTimezoneRule.ofLastWeekday(month, weekday, plainTime, offsetIndicator, n4) : (n < 0 ? new NegativeDayOfMonthPattern(month, n, weekday, plainTime, offsetIndicator, n4) : GregorianTimezoneRule.ofWeekdayAfterDate(month, n, weekday, plainTime, offsetIndicator, n4));
                }
                arrayList2.add((DaylightSavingRule)((Object)serializable));
            }
            return TransitionModel.of(zonalOffset, arrayList, arrayList2);
        }
        catch (DateTimeException dateTimeException) {
            throw new IllegalArgumentException(dateTimeException);
        }
    }
}

