/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.api.APIConfiguration;
import org.identityconnectors.framework.api.ResultsHandlerConfiguration;
import org.identityconnectors.framework.api.operations.APIOperation;
import org.identityconnectors.framework.impl.api.AbstractConnectorInfo;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;

public class APIConfigurationImpl
implements APIConfiguration {
    private ObjectPoolConfiguration connectorPoolConfiguration;
    private ResultsHandlerConfiguration resultsHandlerConfiguration;
    private boolean isConnectorPoolingSupported;
    private ConfigurationPropertiesImpl configurationProperties;
    private int bufferSize = 100;
    private Map<Class<? extends APIOperation>, Integer> timeoutMap = new HashMap<Class<? extends APIOperation>, Integer>();
    private Set<Class<? extends APIOperation>> supportedOperations;
    private transient AbstractConnectorInfo connectorInfo;

    public APIConfigurationImpl() {
    }

    public APIConfigurationImpl(APIConfigurationImpl other) {
        if (null != other.connectorPoolConfiguration) {
            this.setConnectorPoolConfiguration(new ObjectPoolConfiguration(other.connectorPoolConfiguration));
        }
        if (null != other.resultsHandlerConfiguration) {
            this.setResultsHandlerConfiguration(new ResultsHandlerConfiguration(other.resultsHandlerConfiguration));
        }
        this.isConnectorPoolingSupported = other.isConnectorPoolingSupported;
        ConfigurationPropertiesImpl prop = new ConfigurationPropertiesImpl();
        prop.setProperties(other.getConfigurationProperties().getProperties());
        this.setConfigurationProperties(prop);
        this.bufferSize = other.bufferSize;
        this.timeoutMap = new HashMap<Class<? extends APIOperation>, Integer>(other.timeoutMap);
        this.supportedOperations = new HashSet<Class<? extends APIOperation>>(other.supportedOperations);
        this.connectorInfo = other.connectorInfo;
    }

    public AbstractConnectorInfo getConnectorInfo() {
        return this.connectorInfo;
    }

    public void setConnectorInfo(AbstractConnectorInfo connectorInfo) {
        this.connectorInfo = connectorInfo;
    }

    public void setConnectorPoolingSupported(boolean supported) {
        this.isConnectorPoolingSupported = supported;
    }

    public void setConnectorPoolConfiguration(ObjectPoolConfiguration config) {
        this.connectorPoolConfiguration = config;
    }

    public void setConfigurationProperties(ConfigurationPropertiesImpl properties) {
        if (this.configurationProperties != null) {
            this.configurationProperties.setParent(null);
        }
        this.configurationProperties = properties;
        if (this.configurationProperties != null) {
            this.configurationProperties.setParent(this);
        }
    }

    public Map<Class<? extends APIOperation>, Integer> getTimeoutMap() {
        return this.timeoutMap;
    }

    public void setTimeoutMap(Map<Class<? extends APIOperation>, Integer> map) {
        this.timeoutMap = map;
    }

    public void setSupportedOperations(Set<Class<? extends APIOperation>> op) {
        this.supportedOperations = op;
    }

    public boolean isSupportedOperation(Class<? extends APIOperation> api) {
        return this.supportedOperations.contains(api);
    }

    public boolean isConnectorPoolingSupported() {
        return this.isConnectorPoolingSupported;
    }

    public ObjectPoolConfiguration getConnectorPoolConfiguration() {
        if (this.connectorPoolConfiguration == null) {
            this.connectorPoolConfiguration = new ObjectPoolConfiguration();
        }
        return this.connectorPoolConfiguration;
    }

    public ConfigurationPropertiesImpl getConfigurationProperties() {
        return this.configurationProperties;
    }

    public int getTimeout(Class<? extends APIOperation> operation) {
        Integer ret = this.timeoutMap.get(operation);
        if (ret == null) {
            ret = -1;
        }
        return ret;
    }

    public Set<Class<? extends APIOperation>> getSupportedOperations() {
        return CollectionUtil.newReadOnlySet(this.supportedOperations);
    }

    public void setTimeout(Class<? extends APIOperation> operation, int timeout) {
        this.timeoutMap.put(operation, timeout);
    }

    public void setProducerBufferSize(int size) {
        this.bufferSize = size;
    }

    public int getProducerBufferSize() {
        return this.bufferSize;
    }

    public ResultsHandlerConfiguration getResultsHandlerConfiguration() {
        if (null == this.resultsHandlerConfiguration) {
            this.resultsHandlerConfiguration = new ResultsHandlerConfiguration();
        }
        return this.resultsHandlerConfiguration;
    }

    public void setResultsHandlerConfiguration(ResultsHandlerConfiguration config) {
        this.resultsHandlerConfiguration = config;
    }
}

