/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.Set;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public final class DuplicateFilteringResultsHandler
implements SearchResultsHandler {
    private final SearchResultsHandler handler;
    private final Set<String> visitedUIDs = new HashSet<String>();
    private boolean stillHandling;

    public DuplicateFilteringResultsHandler(SearchResultsHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Handler must not be null!");
        }
        this.handler = handler;
    }

    public boolean handle(ConnectorObject object) {
        String uid = object.getUid().getUidValue();
        if (!this.visitedUIDs.add(uid)) {
            return true;
        }
        this.stillHandling = this.handler.handle(object);
        return this.stillHandling;
    }

    public void handleResult(SearchResult result) {
        this.handler.handleResult(result);
    }

    public boolean isStillHandling() {
        return this.stillHandling;
    }
}

