/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.concurrent.atomic.AtomicReference;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.api.operations.SyncApiOp;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.impl.api.local.operations.AttributesToGetResultsHandler;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.NormalizingSyncResultsHandler;
import org.identityconnectors.framework.spi.AttributeNormalizer;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.SyncTokenResultsHandler;
import org.identityconnectors.framework.spi.operations.SyncOp;

public class SyncImpl
extends ConnectorAPIOperationRunner
implements SyncApiOp {
    public SyncImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    public SyncToken sync(ObjectClass objectClass, SyncToken token, SyncResultsHandler handler, OperationOptions options) {
        String[] attrsToGet;
        Assertions.nullCheck((Object)objectClass, (String)"objectClass");
        Assertions.nullCheck((Object)handler, (String)"handler");
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        if ((attrsToGet = options.getAttributesToGet()) != null && attrsToGet.length > 0) {
            handler = new AttributesToGetSyncResultsHandler(handler, attrsToGet);
        }
        if (this.getConnector() instanceof AttributeNormalizer) {
            handler = new NormalizingSyncResultsHandler(handler, this.getNormalizer(objectClass));
        }
        final SyncResultsHandler handlerChain = handler;
        final AtomicReference<Object> result = new AtomicReference<Object>(null);
        ((SyncOp)this.getConnector()).sync(objectClass, token, (SyncResultsHandler)new SyncTokenResultsHandler(){

            public void handleResult(SyncToken token) {
                result.compareAndSet(null, token);
            }

            public boolean handle(SyncDelta delta) {
                return handlerChain.handle(delta);
            }
        }, options);
        return result.get();
    }

    public SyncToken getLatestSyncToken(ObjectClass objectClass) {
        return ((SyncOp)this.getConnector()).getLatestSyncToken(objectClass);
    }

    public static class AttributesToGetSyncResultsHandler
    extends AttributesToGetResultsHandler
    implements SyncResultsHandler {
        private final SyncResultsHandler handler;

        public AttributesToGetSyncResultsHandler(SyncResultsHandler handler, String[] attrsToGet) {
            super(attrsToGet);
            this.handler = handler;
        }

        public boolean handle(SyncDelta delta) {
            SyncDeltaBuilder bld = new SyncDeltaBuilder(delta);
            if (delta.getObject() != null) {
                bld.setObject(this.reduceToAttrsToGet(delta.getObject()));
            }
            return this.handler.handle(bld.build());
        }
    }
}

