/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.server.impl;

import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.server.ConnectorServer;
import org.identityconnectors.framework.server.impl.CCLWatchThread;
import org.identityconnectors.framework.server.impl.CCLWatchThreadFactory;
import org.identityconnectors.framework.server.impl.ConnectionProcessor;

class ConnectionListener
extends CCLWatchThread {
    private static final int INTERNAL_QUEUE_SIZE = 2;
    private static final Log LOG = Log.getLog(ConnectionListener.class);
    private final ConnectorServer connectorServer;
    private final ServerSocket socket;
    private final ExecutorService threadPool;
    private boolean stopped = false;

    public ConnectionListener(ConnectorServer server, ServerSocket socket) {
        super("ConnectionListener");
        this.connectorServer = server;
        this.socket = socket;
        this.threadPool = new ThreadPoolExecutor(server.getMinWorkers(), server.getMaxWorkers(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(2, true), new CCLWatchThreadFactory());
    }

    @Override
    public void run() {
        block8: while (!this.isStopped()) {
            try {
                Socket connection = this.socket.accept();
                ConnectionProcessor processor = new ConnectionProcessor(this.connectorServer, connection);
                while (true) {
                    try {
                        this.threadPool.execute(processor);
                        continue block8;
                    }
                    catch (RejectedExecutionException e) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (Exception e2) {}
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                if (!this.isStopped() || !(e instanceof SocketException)) {
                    LOG.error(e, "Error processing request", new Object[0]);
                }
                if (this.isStopped()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
        }
    }

    private synchronized void markStopped() {
        this.stopped = true;
    }

    private synchronized boolean isStopped() {
        return this.stopped;
    }

    public void shutdown() {
        if (Thread.currentThread() == this) {
            throw new IllegalArgumentException("Shutdown may not be called from this thread");
        }
        if (!this.isStopped()) {
            try {
                this.markStopped();
                this.socket.close();
                this.join();
                this.threadPool.shutdown();
            }
            catch (Exception e) {
                throw ConnectorException.wrap((Throwable)e);
            }
        }
    }
}

