/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.Uid;

public final class ConnectorObject {
    final ObjectClass objectClass;
    final Map<String, Attribute> attributeMap;

    public ConnectorObject(ObjectClass objectClass, Set<? extends Attribute> set) {
        if (objectClass == null) {
            throw new IllegalArgumentException("ObjectClass may not be null");
        }
        if (ObjectClass.ALL.equals(objectClass)) {
            throw new IllegalArgumentException("Connector object class can not be type of __ALL__");
        }
        if (set == null || set.size() == 0) {
            throw new IllegalArgumentException("The set can not be null or empty.");
        }
        this.objectClass = objectClass;
        this.attributeMap = AttributeUtil.toMap(set);
        if (!this.attributeMap.containsKey(Uid.NAME)) {
            throw new IllegalArgumentException("The Attribute set must contain a 'Uid'.");
        }
        if (!this.attributeMap.containsKey(Name.NAME)) {
            throw new IllegalArgumentException("The Attribute set must contain a 'Name'.");
        }
    }

    public Set<Attribute> getAttributes() {
        return CollectionUtil.newReadOnlySet(this.attributeMap.values());
    }

    public Attribute getAttributeByName(String name) {
        return this.attributeMap.get(name);
    }

    public Uid getUid() {
        Attribute uid = this.attributeMap.get(Uid.NAME);
        if (uid instanceof Uid) {
            return (Uid)uid;
        }
        throw new IllegalArgumentException("__UID__ attribute must be instance of Uid");
    }

    public Name getName() {
        Attribute name = this.attributeMap.get(Name.NAME);
        if (name instanceof Name) {
            return (Name)name;
        }
        throw new IllegalArgumentException("__NAME__ attribute must be instance of Name");
    }

    public ObjectClass getObjectClass() {
        return this.objectClass;
    }

    public boolean equals(Object obj) {
        if (obj instanceof ConnectorObject) {
            ConnectorObject other = (ConnectorObject)obj;
            if (!this.objectClass.equals(other.getObjectClass())) {
                return false;
            }
            return CollectionUtil.equals(this.getAttributes(), other.getAttributes());
        }
        return false;
    }

    public int hashCode() {
        return this.getAttributes().hashCode();
    }

    public String toString() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Uid", this.getUid());
        map.put("ObjectClass", this.getObjectClass());
        map.put("Name", this.getName());
        map.put("Attributes", this.getAttributes());
        return ((Object)map).toString();
    }
}

