/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.common.objects.AttributeInfo;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.ObjectClassInfo;

public final class ObjectClassInfoBuilder {
    private boolean isContainer;
    private String type = ObjectClass.ACCOUNT_NAME;
    private Map<String, AttributeInfo> attributeInfoMap = new HashMap<String, AttributeInfo>();
    private static final String FORMAT = "AttributeInfo of name '%s' already exists!";

    public ObjectClassInfoBuilder setType(String type) {
        this.type = type;
        return this;
    }

    public ObjectClassInfoBuilder addAttributeInfo(AttributeInfo info) {
        if (this.attributeInfoMap.containsKey(info.getName())) {
            throw new IllegalArgumentException(String.format(FORMAT, info.getName()));
        }
        this.attributeInfoMap.put(info.getName(), info);
        return this;
    }

    public ObjectClassInfoBuilder addAllAttributeInfo(Collection<AttributeInfo> c) {
        for (AttributeInfo info : c) {
            this.addAttributeInfo(info);
        }
        return this;
    }

    public void setContainer(boolean container) {
        this.isContainer = container;
    }

    public ObjectClassInfo build() {
        if (!this.attributeInfoMap.containsKey(Name.NAME)) {
            this.attributeInfoMap.put(Name.NAME, Name.INFO);
        }
        return new ObjectClassInfo(this.type, CollectionUtil.newSet(this.attributeInfoMap.values()), this.isContainer);
    }
}

