/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.objects.OperationOptionInfo;
import org.identityconnectors.framework.common.objects.QualifiedUid;
import org.identityconnectors.framework.common.objects.SortKey;

public final class OperationOptionInfoBuilder {
    private String name;
    private Class<?> type;

    public OperationOptionInfoBuilder() {
    }

    public OperationOptionInfoBuilder(String name, Class<?> type) {
        this.name = name;
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public OperationOptionInfo build() {
        return new OperationOptionInfo(this.name, this.type);
    }

    public static OperationOptionInfo build(String name, Class<?> type) {
        return new OperationOptionInfoBuilder(name, type).build();
    }

    public static OperationOptionInfo build(String name) {
        return new OperationOptionInfoBuilder(name, String.class).build();
    }

    public static OperationOptionInfo buildAttributesToGet() {
        return OperationOptionInfoBuilder.build("ATTRS_TO_GET", String[].class);
    }

    public static OperationOptionInfo buildRunWithPassword() {
        return OperationOptionInfoBuilder.build("RUN_WITH_PASSWORD", GuardedString.class);
    }

    public static OperationOptionInfo buildRunWithUser() {
        return OperationOptionInfoBuilder.build("RUN_AS_USER");
    }

    public static OperationOptionInfo buildScope() {
        return OperationOptionInfoBuilder.build("SCOPE");
    }

    public static OperationOptionInfo buildContainer() {
        return OperationOptionInfoBuilder.build("CONTAINER", QualifiedUid.class);
    }

    public static OperationOptionInfo buildPagedResultsCookie() {
        return OperationOptionInfoBuilder.build("PAGED_RESULTS_COOKIE");
    }

    public static OperationOptionInfo buildPagedResultsOffset() {
        return OperationOptionInfoBuilder.build("PAGED_RESULTS_OFFSET", Integer.class);
    }

    public static OperationOptionInfo buildPageSize() {
        return OperationOptionInfoBuilder.build("PAGE_SIZE", Integer.class);
    }

    public static OperationOptionInfo buildSortKeys() {
        return OperationOptionInfoBuilder.build("SORT_KEYS", SortKey.class);
    }
}

