/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.dsproxy.support;

import java.sql.Connection;
import net.ttddyy.dsproxy.ConnectionIdManager;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.dsproxy.proxy.JdbcProxyFactory;
import net.ttddyy.dsproxy.proxy.ProxyConfig;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ProxyConnectionAdvice
implements MethodInterceptor {
    private ProxyConfig proxyConfig = ProxyConfig.Builder.create().build();

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object retVal = invocation.proceed();
        if (!(retVal instanceof Connection)) {
            return retVal;
        }
        Connection conn = (Connection)retVal;
        String connId = this.proxyConfig.getConnectionIdManager().getId(conn);
        ConnectionInfo connectionInfo = new ConnectionInfo();
        connectionInfo.setConnectionId(connId);
        connectionInfo.setDataSourceName("");
        if (this.proxyConfig.isRetrieveIsolationLevel()) {
            connectionInfo.setIsolationLevel(conn.getTransactionIsolation());
        }
        return this.proxyConfig.getJdbcProxyFactory().createConnection((Connection)retVal, connectionInfo, this.proxyConfig);
    }

    public JdbcProxyFactory getJdbcProxyFactory() {
        return this.proxyConfig.getJdbcProxyFactory();
    }

    public void setJdbcProxyFactory(JdbcProxyFactory jdbcProxyFactory) {
        this.proxyConfig = ProxyConfig.Builder.from(this.proxyConfig).jdbcProxyFactory(jdbcProxyFactory).build();
    }

    public ConnectionIdManager getConnectionIdManager() {
        return this.proxyConfig.getConnectionIdManager();
    }

    public void setConnectionIdManager(ConnectionIdManager connectionIdManager) {
        this.proxyConfig = ProxyConfig.Builder.from(this.proxyConfig).connectionIdManager(connectionIdManager).build();
    }

    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    public void setProxyConfig(ProxyConfig proxyConfig) {
        this.proxyConfig = proxyConfig;
    }
}

