/*
 * Decompiled with CFR 0.152.
 */
package network.particle.unity;

import androidx.annotation.Keep;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.LogUtils;
import com.connect.common.DisconnectCallback;
import com.connect.common.IConnectAdapter;
import com.connect.common.ILocalAdapter;
import com.connect.common.SignAllCallback;
import com.connect.common.SignCallback;
import com.connect.common.eip4361.Eip4361Message;
import com.connect.common.model.Account;
import com.connect.common.model.ConnectError;
import com.evm.adapter.EVMConnectAdapter;
import com.particle.base.Env;
import com.particle.base.ParticleNetwork;
import com.particle.base.model.ChainType;
import com.particle.base.utils.ChainUtils;
import com.particle.base.utils.MessageProcess;
import com.particle.connect.ParticleConnect;
import com.particle.connect.model.AdapterAccount;
import com.solana.adapter.SolanaConnectAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import network.particle.chains.ChainInfo;
import network.particle.unity.callunity.JavaCallUnityChannel;
import network.particle.unity.model.ConnectSignData;
import network.particle.unity.model.InitData;
import network.particle.unity.model.UnityCallBack;
import network.particle.unity.model.UnityErrorMessage;
import network.particle.unity.module.AABridge;
import network.particle.unity.module.ConnectBridge;
import network.particle.unity.module.UIBridge;
import network.particle.unity.utils.EncodeUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u000e\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u000b\u001a\u00020\n2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\f\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u001c\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0011\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0010\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0007J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0017\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u001a\u001a\u00020\u001b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\u001f\u001a\u00020\b2\b\u0010\u001e\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010\"\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010#\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010$\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010%\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010&\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010'\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\u0012\u0010(\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006)"}, d2={"Lnetwork/particle/unity/UnityBridgeConnect;", "", "()V", "privateKeyAdapter", "Lcom/connect/common/ILocalAdapter;", "getPrivateKeyAdapter", "()Lcom/connect/common/ILocalAdapter;", "adapterBatchSendTransactions", "", "jsonParams", "", "adapterWalletReadyState", "addEthereumChain", "connect", "walletType", "loginParams", "disconnect", "exportPrivateKey", "getAccounts", "getConnectAdapter", "Lcom/connect/common/IConnectAdapter;", "publicAddress", "importMnemonic", "importPrivateKey", "init", "initParams", "isConnect", "", "login", "setChainInfo", "chainParams", "setChainInfoAsync", "setWalletConnectV2SupportChainInfos", "chainsString", "signAllTransactions", "signAndSendTransaction", "signMessage", "signTransaction", "signTypedData", "switchEthereumChain", "verify", "unity-bridge_release"})
@Keep
public final class UnityBridgeConnect {
    @NotNull
    public static final UnityBridgeConnect INSTANCE = new UnityBridgeConnect();

    private UnityBridgeConnect() {
    }

    @JvmStatic
    public static final void init(@Nullable String initParams) {
        Object[] objectArray = new Object[]{"init", initParams};
        LogUtils.d((Object[])objectArray);
        InitData initData2 = (InitData)GsonUtils.fromJson((String)initParams, InitData.class);
        Long l = initData2.chainId;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"initData.chainId");
        ChainInfo chainInfo = ChainUtils.INSTANCE.getChainInfo(((Number)l).longValue());
        String string = initData2.env;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initData.env");
        Env env = Env.valueOf((String)string);
        Intrinsics.checkNotNullExpressionValue((Object)initData2, (String)"initData");
        ConnectBridge.init(env, chainInfo, initData2);
        UIBridge.INSTANCE.init();
    }

    @JvmStatic
    public static final int setChainInfo(@Nullable String chainParams) {
        Object[] objectArray = new Object[]{"setChainName", chainParams};
        LogUtils.d((Object[])objectArray);
        return ConnectBridge.setChainInfo(chainParams) ? 1 : 0;
    }

    @JvmStatic
    public static final void setWalletConnectV2SupportChainInfos(@Nullable String chainsString) {
        Object[] objectArray = new Object[]{"setWalletConnectV2SupportChainInfos", chainsString};
        LogUtils.d((Object[])objectArray);
        ConnectBridge.setWalletConnectV2SupportChainInfos(chainsString);
    }

    @JvmStatic
    public static final void setChainInfoAsync(@Nullable String chainParams) {
        Object[] objectArray = new Object[]{"setChainInfoAsync", chainParams};
        LogUtils.d((Object[])objectArray);
        ConnectBridge.setChainInfoAsync(chainParams);
    }

    @JvmStatic
    public static final void connect(@Nullable String walletType, @Nullable String loginParams) {
        Object[] objectArray = new Object[]{"connect", walletType};
        LogUtils.d((Object[])objectArray);
        ConnectBridge.connect(walletType, loginParams);
    }

    @JvmStatic
    public static final int isConnect(@Nullable String jsonParams) {
        int n;
        Object[] objectArray = new Object[]{"isConnect", jsonParams};
        LogUtils.d((Object[])objectArray);
        try {
            JSONObject jsonObject = new JSONObject(jsonParams);
            String walletType = jsonObject.getString("wallet_type");
            String publicKey = jsonObject.getString("public_address");
            Intrinsics.checkNotNullExpressionValue((Object)publicKey, (String)"publicKey");
            Intrinsics.checkNotNullExpressionValue((Object)walletType, (String)"walletType");
            IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(publicKey, walletType);
            int result = 0;
            if (connectAdapter != null) {
                result = connectAdapter.connected(publicKey) ? 1 : 0;
            }
            Object[] objectArray2 = new Object[]{"isConnect", result};
            LogUtils.d((Object[])objectArray2);
            n = result;
        }
        catch (Exception e) {
            e.printStackTrace();
            n = 0;
        }
        return n;
    }

    @JvmStatic
    @NotNull
    public static final String getAccounts(@NotNull String walletType) {
        Intrinsics.checkNotNullParameter((Object)walletType, (String)"walletType");
        Object[] objectArray = new Object[]{"getAccounts", walletType};
        LogUtils.d((Object[])objectArray);
        List adapterAccounts = ParticleConnect.getAccounts((ChainType[])new ChainType[0]);
        List accounts = new ArrayList();
        for (AdapterAccount adapterAccount : adapterAccounts) {
            IConnectAdapter connectAdapter = adapterAccount.component1();
            List accounts1 = adapterAccount.component2();
            if (!Intrinsics.areEqual((Object)connectAdapter.getName(), (Object)walletType)) continue;
            accounts = accounts1;
            break;
        }
        String string = GsonUtils.toJson((Object)accounts);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toJson(accounts)");
        return string;
    }

    @JvmStatic
    public static final void disconnect(@Nullable String jsonParams) {
        Object[] objectArray = new Object[]{"disconnect", jsonParams};
        LogUtils.d((Object[])objectArray);
        try {
            JSONObject jsonObject = new JSONObject(jsonParams);
            String walletType = jsonObject.getString("wallet_type");
            String publicAddress = jsonObject.getString("public_address");
            Intrinsics.checkNotNullExpressionValue((Object)publicAddress, (String)"publicAddress");
            Intrinsics.checkNotNullExpressionValue((Object)walletType, (String)"walletType");
            IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(publicAddress, walletType);
            if (connectAdapter == null) {
                JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
                return;
            }
            connectAdapter.disconnect(publicAddress, new DisconnectCallback(connectAdapter, publicAddress){
                final /* synthetic */ IConnectAdapter $connectAdapter;
                final /* synthetic */ String $publicAddress;
                {
                    this.$connectAdapter = $connectAdapter;
                    this.$publicAddress = $publicAddress;
                }

                public void onDisconnected() {
                    JavaCallUnityChannel.getInstance().disconnectCallBack(UnityCallBack.success("success"));
                    String string = this.$publicAddress;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"publicAddress");
                    UIBridge.INSTANCE.logoutWallet(this.$connectAdapter, string);
                }

                public void onError(@NotNull ConnectError connectError) {
                    Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                    JavaCallUnityChannel.getInstance().disconnectCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
                }
            });
        }
        catch (JSONException e) {
            JavaCallUnityChannel.getInstance().disconnectCallBack(UnityCallBack.failed(UnityErrorMessage.exceptionMsg("data error")));
        }
    }

    @JvmStatic
    public static final void signMessage(@Nullable String jsonParams) {
        Object[] objectArray = new Object[]{"signMessage", jsonParams};
        LogUtils.d((Object[])objectArray);
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.message;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.message");
        String message = MessageProcess.start((String)string3);
        String string4 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signData.publicAddress");
        IConnectAdapter.DefaultImpls.signMessage$default((IConnectAdapter)connectAdapter, (String)string4, (String)message, (SignCallback)new SignCallback(){

            public void onSigned(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                JavaCallUnityChannel.getInstance().signMessageCallback(UnityCallBack.success(s));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().signMessageCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
            }
        }, null, (int)8, null);
    }

    @JvmStatic
    @NotNull
    public static final String adapterWalletReadyState(@Nullable String jsonParams) {
        Object[] objectArray = new Object[]{"signMessage", jsonParams};
        LogUtils.d((Object[])objectArray);
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        List adapters = ParticleConnect.getAdapters((ChainType[])new ChainType[0]);
        for (IConnectAdapter adapter : adapters) {
            if (!StringsKt.equals((String)adapter.getName(), (String)signData.walletType, (boolean)true)) continue;
            String name = adapter.getReadyState().name();
            StringBuilder stringBuilder = new StringBuilder();
            String string = name.substring(0, 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String string2 = string;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string3 = string2.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(locale)");
            StringBuilder stringBuilder2 = stringBuilder.append(string3);
            String string4 = name.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            return stringBuilder2.append(string4).toString();
        }
        return "";
    }

    @JvmStatic
    public static final void signAndSendTransaction(@Nullable String jsonParams) {
        String string = jsonParams;
        Intrinsics.checkNotNull((Object)string);
        ConnectBridge.signAndSendTransaction(string);
    }

    @JvmStatic
    public static final void signTransaction(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String transaction = signData.transaction;
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.publicAddress");
        Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"transaction");
        IConnectAdapter.DefaultImpls.signTransaction$default((IConnectAdapter)connectAdapter, (String)string3, (String)transaction, (SignCallback)new SignCallback(){

            public void onSigned(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                JavaCallUnityChannel.getInstance().signTransactionCallback(UnityCallBack.success(s));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().signTransactionCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
            }
        }, null, (int)8, null);
    }

    @JvmStatic
    public static final void signAllTransactions(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        List<String> list2 = signData.transactions;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"signData.transactions");
        Collection $this$toTypedArray$iv = list2;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        String[] trans2 = stringArray;
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.publicAddress");
        IConnectAdapter.DefaultImpls.signAllTransactions$default((IConnectAdapter)connectAdapter, (String)string3, (String[])trans2, (SignAllCallback)new SignAllCallback(){

            public void onSigned(@NotNull List<String> list2) {
                Intrinsics.checkNotNullParameter(list2, (String)"list");
                JavaCallUnityChannel.getInstance().signTransactionCallback(UnityCallBack.success(list2));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().signTransactionCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
            }
        }, null, (int)8, null);
    }

    @JvmStatic
    public static final void adapterBatchSendTransactions(@Nullable String jsonParams) {
        String string = jsonParams;
        Intrinsics.checkNotNull((Object)string);
        AABridge.adapterBatchSendTransactions(string);
    }

    @JvmStatic
    public static final void signTypedData(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.publicAddress");
        String string4 = signData.message;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signData.message");
        IConnectAdapter.DefaultImpls.signTypedData$default((IConnectAdapter)connectAdapter, (String)string3, (String)EncodeUtils.INSTANCE.encode(string4), (SignCallback)new SignCallback(){

            public void onSigned(@NotNull String s) {
                Intrinsics.checkNotNullParameter((Object)s, (String)"s");
                JavaCallUnityChannel.getInstance().signTypeDataCallback(UnityCallBack.success(s));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().signTypeDataCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
            }
        }, null, (int)8, null);
    }

    @JvmStatic
    public static final void importMnemonic(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        ILocalAdapter connectAdapter = INSTANCE.getPrivateKeyAdapter();
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectAdapter, signData, null){
            int label;
            final /* synthetic */ ILocalAdapter $connectAdapter;
            final /* synthetic */ ConnectSignData $signData;
            {
                this.$connectAdapter = $connectAdapter;
                this.$signData = $signData;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$signData.mnemonic;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"signData.mnemonic");
                        this.label = 1;
                        v1 = this.$connectAdapter.importWalletFromMnemonic(v0, (Continuation)this);
                        ** if (v1 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl19:
                            // 2 sources

                            account = (Account)v1;
                            JavaCallUnityChannel.getInstance().importMnemonicCallback(UnityCallBack.success(account));
                        }
                        catch (Exception e) {
                            JavaCallUnityChannel.getInstance().importMnemonicCallback(UnityCallBack.failed(UnityErrorMessage.exceptionMsg(e.getMessage())));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    public static final void importPrivateKey(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        ILocalAdapter connectAdapter = INSTANCE.getPrivateKeyAdapter();
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectAdapter, signData, null){
            int label;
            final /* synthetic */ ILocalAdapter $connectAdapter;
            final /* synthetic */ ConnectSignData $signData;
            {
                this.$connectAdapter = $connectAdapter;
                this.$signData = $signData;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$signData.privateKey;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"signData.privateKey");
                        this.label = 1;
                        v1 = this.$connectAdapter.importWalletFromPrivateKey(v0, (Continuation)this);
                        ** if (v1 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl19:
                            // 2 sources

                            account = (Account)v1;
                            JavaCallUnityChannel.getInstance().importWalletFromPrivateKeyCallBack(UnityCallBack.success(account));
                        }
                        catch (Exception e) {
                            JavaCallUnityChannel.getInstance().importWalletFromPrivateKeyCallBack(UnityCallBack.failed(UnityErrorMessage.exceptionMsg(e.getMessage())));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    public static final void exportPrivateKey(@Nullable String jsonParams) {
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        ILocalAdapter connectAdapter = INSTANCE.getPrivateKeyAdapter();
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        BuildersKt.launch$default((CoroutineScope)CoroutineScopeKt.CoroutineScope((CoroutineContext)((CoroutineContext)Dispatchers.getIO())), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(connectAdapter, signData, null){
            int label;
            final /* synthetic */ ILocalAdapter $connectAdapter;
            final /* synthetic */ ConnectSignData $signData;
            {
                this.$connectAdapter = $connectAdapter;
                this.$signData = $signData;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        v0 = this.$signData.publicAddress;
                        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"signData.publicAddress");
                        this.label = 1;
                        v1 = this.$connectAdapter.exportWalletPrivateKey(v0, (Continuation)this);
                        ** if (v1 != var3_2) goto lbl13
lbl12:
                        // 1 sources

                        return var3_2;
lbl13:
                        // 1 sources

                        ** GOTO lbl19
                    }
                    case 1: {
                        try {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl19:
                            // 2 sources

                            privateKey = (String)v1;
                            JavaCallUnityChannel.getInstance().exportPrivateKeyCallback(UnityCallBack.success(privateKey));
                        }
                        catch (Exception e) {
                            JavaCallUnityChannel.getInstance().exportPrivateKeyCallback(UnityCallBack.failed(UnityErrorMessage.exceptionMsg(e.getMessage())));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    @JvmStatic
    public static final void login(@Nullable String jsonParams) {
        Object[] objectArray = new Object[]{"login", jsonParams};
        LogUtils.d((Object[])objectArray);
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().signLoginCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.domain;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.domain");
        String string4 = signData.uri;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signData.uri");
        String string5 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"signData.publicAddress");
        Eip4361Message message = Eip4361Message.Companion.createWithRequiredParameter(string3, string4, string5);
        String string6 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"signData.publicAddress");
        connectAdapter.login(string6, message, new SignCallback(message){
            final /* synthetic */ Eip4361Message $message;
            {
                this.$message = $message;
            }

            public void onSigned(@NotNull String signature) {
                Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                Map map = new HashMap<K, V>();
                map.put("signature", signature);
                map.put("message", this.$message.toString());
                JavaCallUnityChannel.getInstance().signLoginCallback(UnityCallBack.success(map));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().signLoginCallback(UnityCallBack.failed(UnityErrorMessage.parseConnectError(connectError)));
            }
        });
    }

    @JvmStatic
    public static final void verify(@Nullable String jsonParams) {
        Object[] objectArray = new Object[]{"verify", jsonParams};
        LogUtils.d((Object[])objectArray);
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        String string3 = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"signData.publicAddress");
        String string4 = signData.signature;
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"signData.signature");
        String string5 = signData.message;
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"signData.message");
        if (connectAdapter.verify(string3, string4, string5)) {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.success("success"));
        } else {
            JavaCallUnityChannel.getInstance().verifyCallBack(UnityCallBack.failed("failed"));
        }
    }

    @JvmStatic
    public static final void switchEthereumChain(@Nullable String jsonParams) {
        throw new Exception("not support");
    }

    @JvmStatic
    public static final void addEthereumChain(@Nullable String jsonParams) {
        throw new Exception("not support");
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final IConnectAdapter getConnectAdapter(@NotNull String publicAddress, @NotNull String walletType) {
        Intrinsics.checkNotNullParameter((Object)publicAddress, (String)"publicAddress");
        Intrinsics.checkNotNullParameter((Object)walletType, (String)"walletType");
        try {
            void $this$filterTo$iv$iv;
            void $this$filterTo$iv$iv2;
            Iterable $this$filter$iv = ParticleConnect.getAdapters((ChainType[])new ChainType[0]);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Iterable destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                IConnectAdapter it = (IConnectAdapter)element$iv$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)it.getName(), (String)walletType, (boolean)true)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List allAdapters = (List)destination$iv$iv;
            Iterable $this$filter$iv2 = allAdapters;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                boolean bl;
                block8: {
                    IConnectAdapter it = (IConnectAdapter)element$iv$iv;
                    boolean bl2 = false;
                    List accounts = it.getAccounts();
                    Iterable $this$any$iv = accounts;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            Account account = (Account)element$iv;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)account.getPublicAddress(), (String)publicAddress, (boolean)true)) continue;
                            bl = true;
                            break block8;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List adapters = (List)destination$iv$iv2;
            IConnectAdapter connectAdapter = null;
            if (!((Collection)adapters).isEmpty()) {
                connectAdapter = (IConnectAdapter)adapters.get(0);
            }
            return connectAdapter;
        }
        catch (Exception e) {
            return null;
        }
    }

    private final ILocalAdapter getPrivateKeyAdapter() {
        List allAdapters = ParticleConnect.getAdapters((ChainType[])new ChainType[0]);
        if (ParticleNetwork.isEvmChain()) {
            for (IConnectAdapter adapter : allAdapters) {
                if (!(adapter instanceof EVMConnectAdapter)) continue;
                return (ILocalAdapter)adapter;
            }
        } else {
            for (IConnectAdapter adapter : allAdapters) {
                if (!(adapter instanceof SolanaConnectAdapter)) continue;
                return (ILocalAdapter)adapter;
            }
        }
        return null;
    }
}

