/*
 * Decompiled with CFR 0.152.
 */
package network.particle.unity.module;

import android.app.Application;
import android.text.TextUtils;
import com.blankj.utilcode.util.GsonUtils;
import com.blankj.utilcode.util.LogUtils;
import com.connect.common.ConnectCallback;
import com.connect.common.ConnectConfig;
import com.connect.common.IConnectAdapter;
import com.connect.common.TransactionCallback;
import com.connect.common.model.Account;
import com.connect.common.model.ConnectError;
import com.evm.adapter.EVMConnectAdapter;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.particle.base.Env;
import com.particle.base.ParticleNetwork;
import com.particle.base.data.FeeQuote;
import com.particle.base.iaa.FeeMode;
import com.particle.base.iaa.FeeModeGasless;
import com.particle.base.iaa.FeeModeNative;
import com.particle.base.iaa.FeeModeToken;
import com.particle.base.model.ChainType;
import com.particle.base.model.DAppMetadata;
import com.particle.base.model.LoginType;
import com.particle.base.model.ResultCallback;
import com.particle.base.model.SupportAuthType;
import com.particle.base.utils.ChainUtils;
import com.particle.connect.ParticleConnect;
import com.particle.network.ParticleNetworkAuth;
import com.phantom.adapter.PhantomConnectAdapter;
import com.solana.adapter.SolanaConnectAdapter;
import com.unity3d.player.UnityPlayer;
import com.wallet.connect.adapter.BitKeepConnectAdapter;
import com.wallet.connect.adapter.ImTokenConnectAdapter;
import com.wallet.connect.adapter.MetaMaskConnectAdapter;
import com.wallet.connect.adapter.RainbowConnectAdapter;
import com.wallet.connect.adapter.TrustConnectAdapter;
import com.wallet.connect.adapter.WalletConnectAdapter;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import network.particle.chains.ChainInfo;
import network.particle.unity.UnityBridgeConnect;
import network.particle.unity.callunity.JavaCallUnityChannel;
import network.particle.unity.model.ChainData;
import network.particle.unity.model.ConnectSignData;
import network.particle.unity.model.InitData;
import network.particle.unity.model.LoginData;
import network.particle.unity.model.RpcUrl;
import network.particle.unity.model.UnityCallBack;
import network.particle.unity.model.UnityErrorMessage;
import network.particle.unity.module.UIBridge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import particle.auth.adapter.ParticleConnectAdapter;
import particle.auth.adapter.ParticleConnectConfig;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0007J \u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u0018\u001a\u00020\u00062\b\u0010\u0017\u001a\u0004\u0018\u00010\bH\u0007J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\bH\u0007J\u0010\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u001c\u001a\u00020\bH\u0007R\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lnetwork/particle/unity/module/ConnectBridge;", "", "()V", "isConnectInit", "", "connect", "", "walletType", "", "loginParams", "init", "env", "Lcom/particle/base/Env;", "chainInfo", "Lnetwork/particle/chains/ChainInfo;", "initData", "Lnetwork/particle/unity/model/InitData;", "initAdapter", "", "Lcom/connect/common/IConnectAdapter;", "rpcUrl", "Lnetwork/particle/unity/model/RpcUrl;", "setChainInfo", "chainParams", "setChainInfoAsync", "setWalletConnectV2SupportChainInfos", "chainsString", "signAndSendTransaction", "jsonParams", "unity-bridge_release"})
public final class ConnectBridge {
    @NotNull
    public static final ConnectBridge INSTANCE = new ConnectBridge();
    @JvmField
    public static boolean isConnectInit;

    private ConnectBridge() {
    }

    @JvmStatic
    public static final void init(@NotNull Env env, @NotNull ChainInfo chainInfo, @NotNull InitData initData2) {
        Intrinsics.checkNotNullParameter((Object)env, (String)"env");
        Intrinsics.checkNotNullParameter((Object)chainInfo, (String)"chainInfo");
        Intrinsics.checkNotNullParameter((Object)initData2, (String)"initData");
        DAppMetadata dAppMetadata = initData2.metadata;
        RpcUrl rpcUrl = initData2.rpcUrl;
        Application application = UnityPlayer.currentActivity.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"currentActivity.application");
        ParticleConnect.init((Application)application, (Env)env, (ChainInfo)chainInfo, (DAppMetadata)dAppMetadata, (Function0)((Function0)new Function0<List<? extends IConnectAdapter>>(rpcUrl){
            final /* synthetic */ RpcUrl $rpcUrl;
            {
                this.$rpcUrl = $rpcUrl;
                super(0);
            }

            @NotNull
            public final List<IConnectAdapter> invoke() {
                return ConnectBridge.access$initAdapter(ConnectBridge.INSTANCE, this.$rpcUrl);
            }
        }));
        isConnectInit = true;
    }

    @JvmStatic
    public static final boolean setChainInfo(@Nullable String chainParams) {
        boolean bl;
        ChainData chainData = (ChainData)GsonUtils.fromJson((String)chainParams, ChainData.class);
        try {
            Long l = chainData.chainId;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"chainData.chainId");
            ChainInfo chainInfo = ChainUtils.INSTANCE.getChainInfo(((Number)l).longValue());
            ParticleConnect.setChain((ChainInfo)chainInfo);
            bl = true;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[]{"setChainName", e.getMessage()};
            LogUtils.e((Object[])objectArray);
            bl = false;
        }
        return bl;
    }

    @JvmStatic
    public static final void setWalletConnectV2SupportChainInfos(@Nullable String chainsString) {
        Object[] objectArray = new Object[]{"setWalletConnectV2SupportChainInfos", chainsString};
        LogUtils.d((Object[])objectArray);
        List initData2 = (List)GsonUtils.fromJson((String)chainsString, (Type)new TypeToken<List<? extends InitData>>(){}.getType());
        List chainInfos = new ArrayList();
        for (InitData data : initData2) {
            Long l = data.chainId;
            Intrinsics.checkNotNullExpressionValue((Object)l, (String)"data.chainId");
            chainInfos.add(ChainUtils.INSTANCE.getChainInfo(((Number)l).longValue()));
        }
        ParticleConnect.setWalletConnectV2SupportChainInfos((List)chainInfos);
    }

    @JvmStatic
    public static final void setChainInfoAsync(@Nullable String chainParams) {
        ChainData chainData = (ChainData)GsonUtils.fromJson((String)chainParams, ChainData.class);
        Long l = chainData.chainId;
        Intrinsics.checkNotNullExpressionValue((Object)l, (String)"chainData.chainId");
        ChainInfo chainInfo = ChainUtils.INSTANCE.getChainInfo(((Number)l).longValue());
        ParticleNetworkAuth.switchChain((ParticleNetwork)ParticleNetwork.INSTANCE, (ChainInfo)chainInfo, (ResultCallback)new ResultCallback(chainInfo){
            final /* synthetic */ ChainInfo $chainInfo;
            {
                this.$chainInfo = $chainInfo;
            }

            public void success() {
                ParticleConnect.setChain((ChainInfo)this.$chainInfo);
                String gson = GsonUtils.toJson((Object)UnityCallBack.success("success"));
                Object[] objectArray = new Object[]{"Connect setChainNameAsync success", gson};
                LogUtils.d((Object[])objectArray);
                JavaCallUnityChannel.getInstance().setParticleConnectChainInfoAsyncCallBack(gson);
            }

            public void failure() {
                String gson = GsonUtils.toJson((Object)UnityCallBack.failed("failed"));
                Object[] objectArray = new Object[]{"Connect setChainNameAsync failure", gson};
                LogUtils.d((Object[])objectArray);
                JavaCallUnityChannel.getInstance().setParticleConnectChainInfoAsyncCallBack(gson);
            }
        });
    }

    @JvmStatic
    public static final void connect(@Nullable String walletType, @Nullable String loginParams) {
        ConnectConfig config = null;
        try {
            if (!TextUtils.isEmpty((CharSequence)loginParams)) {
                String string;
                LoginData loginData = (LoginData)GsonUtils.fromJson((String)loginParams, LoginData.class);
                if (TextUtils.isEmpty((CharSequence)loginData.account)) {
                    string = "";
                } else {
                    String string2 = loginData.account;
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n                    lo\u2026account\n                }");
                }
                String account = string;
                int supportAuthType = SupportAuthType.NONE.getValue();
                int n = loginData.supportAuthTypeValues.size();
                for (int i = 0; i < n; ++i) {
                    try {
                        String supportType;
                        String string3;
                        Intrinsics.checkNotNullExpressionValue((Object)loginData.supportAuthTypeValues.get(i), (String)"loginData.supportAuthTypeValues[i]");
                        Locale locale = Locale.getDefault();
                        Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                        Intrinsics.checkNotNullExpressionValue((Object)string3.toUpperCase(locale), (String)"this as java.lang.String).toUpperCase(locale)");
                        SupportAuthType authType = SupportAuthType.valueOf((String)supportType);
                        supportAuthType |= authType.getValue();
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                String string4 = loginData.loginType;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"loginData.loginType");
                String i = string4;
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string5 = i.toUpperCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toUpperCase(locale)");
                config = (ConnectConfig)new ParticleConnectConfig(LoginType.valueOf((String)string5), supportAuthType, account, null);
                String configJson = new Gson().toJson((Object)config);
                Object[] objectArray = new Object[]{"Connect connect config", configJson};
                LogUtils.d((Object[])objectArray);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        IConnectAdapter connectAdapter = null;
        List adapters = ParticleConnect.getAdapters((ChainType[])new ChainType[0]);
        for (IConnectAdapter adapter : adapters) {
            if (!StringsKt.equals((String)adapter.getName(), (String)walletType, (boolean)true)) continue;
            connectAdapter = adapter;
            break;
        }
        IConnectAdapter finalConnectAdapter = connectAdapter;
        IConnectAdapter iConnectAdapter = connectAdapter;
        Intrinsics.checkNotNull(iConnectAdapter);
        iConnectAdapter.connect(config, new ConnectCallback(finalConnectAdapter){
            final /* synthetic */ IConnectAdapter $finalConnectAdapter;
            {
                this.$finalConnectAdapter = $finalConnectAdapter;
            }

            public void onConnected(@NotNull Account account) {
                Intrinsics.checkNotNullParameter((Object)account, (String)"account");
                String string = account.getPublicAddress();
                IConnectAdapter iConnectAdapter = this.$finalConnectAdapter;
                Intrinsics.checkNotNull((Object)iConnectAdapter);
                UIBridge.INSTANCE.createSelectedWallet(string, iConnectAdapter);
                Object[] objectArray = new Object[]{"onConnected", account.toString()};
                LogUtils.d((Object[])objectArray);
                JavaCallUnityChannel.getInstance().connectCallback(UnityCallBack.success(account));
            }

            public void onError(@NotNull ConnectError connectError) {
                Intrinsics.checkNotNullParameter((Object)connectError, (String)"connectError");
                JavaCallUnityChannel.getInstance().connectCallback(UnityCallBack.failed(connectError.getMessage()));
            }
        });
    }

    @JvmStatic
    public static final void signAndSendTransaction(@NotNull String jsonParams) {
        Intrinsics.checkNotNullParameter((Object)jsonParams, (String)"jsonParams");
        Object[] objectArray = new Object[]{"signAndSendTransaction", jsonParams};
        LogUtils.d((Object[])objectArray);
        ConnectSignData signData = (ConnectSignData)GsonUtils.fromJson((String)jsonParams, ConnectSignData.class);
        String transaction = signData.transaction;
        String string = signData.publicAddress;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"signData.publicAddress");
        String string2 = signData.walletType;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"signData.walletType");
        IConnectAdapter connectAdapter = UnityBridgeConnect.getConnectAdapter(string, string2);
        if (connectAdapter == null) {
            JavaCallUnityChannel.getInstance().signAndSendTransactionConnectCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError((ConnectError)new ConnectError.Unauthorized())));
            return;
        }
        if (ParticleNetwork.isAAModeEnable()) {
            FeeMode feeMode = (FeeMode)new FeeModeNative(null, 1, null);
            if (signData.feeMode != null) {
                FeeMode feeMode2;
                String option = signData.feeMode.getOption();
                String string3 = option;
                if (Intrinsics.areEqual((Object)string3, (Object)"custom")) {
                    FeeQuote feeQuote = signData.feeMode.getFeeQuote();
                    Intrinsics.checkNotNull((Object)feeQuote);
                    FeeQuote feeQuote2 = feeQuote;
                    String string4 = signData.feeMode.getTokenPaymasterAddress();
                    Intrinsics.checkNotNull((Object)string4);
                    feeMode2 = (FeeMode)new FeeModeToken(feeQuote2, string4);
                } else {
                    feeMode2 = Intrinsics.areEqual((Object)string3, (Object)"gasless") ? (FeeMode)new FeeModeGasless(null, 1, null) : (FeeMode)new FeeModeNative(null, 1, null);
                }
                feeMode = feeMode2;
            }
            String string5 = signData.publicAddress;
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"signData.publicAddress");
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"transaction");
            IConnectAdapter.DefaultImpls.signAndSendTransaction$default((IConnectAdapter)connectAdapter, (String)string5, (String)transaction, (FeeMode)feeMode, (TransactionCallback)new TransactionCallback(){

                public void onError(@NotNull ConnectError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    Object[] objectArray = new Object[]{"onError", error.toString()};
                    LogUtils.d((Object[])objectArray);
                    JavaCallUnityChannel.getInstance().signAndSendTransactionConnectCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError(error)));
                }

                public void onTransaction(@Nullable String transactionId) {
                    Object[] objectArray = new Object[]{"onTransaction", transactionId};
                    LogUtils.d((Object[])objectArray);
                    JavaCallUnityChannel.getInstance().signAndSendTransactionConnectCallBack(UnityCallBack.success(transactionId));
                }
            }, null, (int)16, null);
        } else {
            String string6 = signData.publicAddress;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"signData.publicAddress");
            Intrinsics.checkNotNullExpressionValue((Object)transaction, (String)"transaction");
            IConnectAdapter.DefaultImpls.signAndSendTransaction$default((IConnectAdapter)connectAdapter, (String)string6, (String)transaction, (TransactionCallback)new TransactionCallback(){

                public void onError(@NotNull ConnectError error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    Object[] objectArray = new Object[]{"onError", error.toString()};
                    LogUtils.d((Object[])objectArray);
                    JavaCallUnityChannel.getInstance().signAndSendTransactionConnectCallBack(UnityCallBack.failed(UnityErrorMessage.parseConnectError(error)));
                }

                public void onTransaction(@Nullable String transactionId) {
                    Object[] objectArray = new Object[]{"onTransaction", transactionId};
                    LogUtils.d((Object[])objectArray);
                    JavaCallUnityChannel.getInstance().signAndSendTransactionConnectCallBack(UnityCallBack.success(transactionId));
                }
            }, null, (int)8, null);
        }
    }

    private final List<IConnectAdapter> initAdapter(RpcUrl rpcUrl) {
        Object[] objectArray = new IConnectAdapter[]{(IConnectAdapter)new ParticleConnectAdapter(), (IConnectAdapter)new MetaMaskConnectAdapter(), (IConnectAdapter)new RainbowConnectAdapter(), (IConnectAdapter)new TrustConnectAdapter(), (IConnectAdapter)new ImTokenConnectAdapter(), (IConnectAdapter)new BitKeepConnectAdapter(), (IConnectAdapter)new WalletConnectAdapter(), (IConnectAdapter)new PhantomConnectAdapter()};
        List adapters = CollectionsKt.mutableListOf((Object[])objectArray);
        if (rpcUrl != null) {
            adapters.add(new EVMConnectAdapter(rpcUrl.evmUrl));
        } else {
            adapters.add(new EVMConnectAdapter(null, 1, null));
        }
        if (rpcUrl != null) {
            adapters.add(new SolanaConnectAdapter(rpcUrl.solUrl));
        } else {
            adapters.add(new SolanaConnectAdapter(null, 1, null));
        }
        return adapters;
    }

    public static final /* synthetic */ List access$initAdapter(ConnectBridge $this, RpcUrl rpcUrl) {
        return $this.initAdapter(rpcUrl);
    }
}

