/*
 * Decompiled with CFR 0.152.
 */
package network.particle.unity.utils;

import com.blankj.utilcode.util.GsonUtils;
import com.particle.api.infrastructure.db.result.TokenInfoJoinSplTokenRates;
import com.particle.api.infrastructure.db.table.NftInfo;
import com.particle.api.infrastructure.db.table.TransInfo;
import com.particle.api.infrastructure.db.table.TransInfoEvm;
import com.particle.api.service.data.TokenNFTResult;
import com.particle.base.ParticleNetwork;
import java.util.ArrayList;
import java.util.List;
import network.particle.unity.model.EvmTransData;
import network.particle.unity.model.SolTransData;
import network.particle.unity.model.TokenNFTs;

public class CallNativeParser {
    public static TokenNFTs tokenNFTResult(TokenNFTResult result) {
        List tokens = result.getTokens();
        List nfts = result.getNfts();
        TokenNFTs tokenNFTs = new TokenNFTs();
        ArrayList<TokenNFTs.TokensDTO> tokensDTO = new ArrayList<TokenNFTs.TokensDTO>();
        for (TokenInfoJoinSplTokenRates token : tokens) {
            TokenNFTs.TokensDTO tokensDTO1 = new TokenNFTs.TokensDTO(token.getTokenInfo().getAddress(), token.getTokenInfo().getAmount() + "", token.getTokenInfo().getDecimals(), token.getTokenInfo().getUpdateTime(), token.getSymbol(), token.getLogoURI());
            tokensDTO.add(tokensDTO1);
        }
        ArrayList<TokenNFTs.NftsDTO> nftsDTO = new ArrayList<TokenNFTs.NftsDTO>();
        for (NftInfo nft : nfts) {
            String nftData = ParticleNetwork.isEvmChain() ? GsonUtils.toJson((Object)nft.getEvmData()) : GsonUtils.toJson((Object)nft.getSolData());
            TokenNFTs.NftsDTO nftsDTO1 = new TokenNFTs.NftsDTO(nft.getMint(), nft.getImage(), nft.getSymbol(), nft.getName(), nft.getSellerFeeBasisPoints(), nft.getDescription(), nft.getExternalUrl(), nft.getAnimationUrl(), nftData, nft.isSemiFungible(), nft.getTokenId(), nft.getTokenBalance());
            nftsDTO.add(nftsDTO1);
        }
        tokenNFTs.tokens = tokensDTO;
        tokenNFTs.nfts = nftsDTO;
        return tokenNFTs;
    }

    public static List<SolTransData> solTransDataList(List<? extends TransInfo> transInfos) {
        ArrayList<SolTransData> solTransData = new ArrayList<SolTransData>();
        for (TransInfo transInfo : transInfos) {
            solTransData.add(new SolTransData(transInfo.getFrom(), transInfo.getTo(), transInfo.getType(), transInfo.getLamportsChange(), transInfo.getLamportsFee(), transInfo.getSignature(), transInfo.getBlockTime(), transInfo.getStatus().equals("success") ? 3 : 4, GsonUtils.toJson((Object)transInfo.getData()), transInfo.getMint()));
        }
        return solTransData;
    }

    public static List<EvmTransData> evmTransDataList(List<? extends TransInfoEvm> transInfos) {
        ArrayList<EvmTransData> evmTransData = new ArrayList<EvmTransData>();
        for (TransInfoEvm transInfoEvm : transInfos) {
            evmTransData.add(new EvmTransData(transInfoEvm.getFrom(), transInfoEvm.getTo(), transInfoEvm.getHash(), transInfoEvm.getValue(), transInfoEvm.getData(), transInfoEvm.getGasLimit(), transInfoEvm.getGasSpent(), transInfoEvm.getGasPrice(), transInfoEvm.getFees(), transInfoEvm.getType(), transInfoEvm.getNonce(), transInfoEvm.getMaxPriorityFeePerGas(), transInfoEvm.getMaxFeePerGas(), transInfoEvm.getTimestamp(), transInfoEvm.getStatus()));
        }
        return evmTransData;
    }
}

