/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.autoconfig.postgres;

import liquibase.integration.spring.SpringLiquibase;
import nl._42.boot.docker.autoconfig.postgres.DockerPostgresBean;
import nl._42.boot.docker.autoconfig.postgres.DockerPostgresDependencyPostProcessor;
import nl._42.boot.docker.postgres.DockerPostgresBootSequence;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.AllNestedConditions;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ConfigurationCondition;

@Configuration
@ConditionalOnProperty(prefix="docker.postgres", name={"enabled"}, havingValue="true", matchIfMissing=true)
@ConditionalOnClass(value={DockerPostgresBootSequence.class})
@AutoConfigureAfter(value={LiquibaseAutoConfiguration.class})
@EnableConfigurationProperties(value={DockerPostgresProperties.class})
public class DockerPostgresAutoConfiguration {
    public static final String DEPEND_ON_BEAN = "dockerPostgresBean";

    @Bean
    @Conditional(value={OnDockerPostgresCondition.class})
    public DockerPostgresDependencyPostProcessor docker42DatabaseBeanLiquibaseDependencyPostProcessor() {
        return new DockerPostgresDependencyPostProcessor(DEPEND_ON_BEAN);
    }

    static class OnDockerPostgresCondition
    extends AllNestedConditions {
        OnDockerPostgresCondition() {
            super(ConfigurationCondition.ConfigurationPhase.REGISTER_BEAN);
        }

        @ConditionalOnBean(value={SpringLiquibase.class})
        static class HasSpringLiquibase {
            HasSpringLiquibase() {
            }
        }
    }

    @Configuration
    @EnableConfigurationProperties(value={DataSourceProperties.class, DockerPostgresProperties.class})
    public static class Docker42Configuration {
        private final DockerPostgresProperties properties;
        private final DataSourceProperties dataSourceProperties;

        public Docker42Configuration(DockerPostgresProperties properties, DataSourceProperties dataSourceProperties) {
            this.properties = properties;
            this.dataSourceProperties = dataSourceProperties;
        }

        @Bean
        @Conditional(value={OnDockerPostgresCondition.class})
        public DockerPostgresBean dockerPostgresBean() {
            return new DockerPostgresBean(this.properties, this.dataSourceProperties);
        }
    }
}

