/*
 * Decompiled with CFR 0.152.
 */
package nl._42.boot.docker.autoconfig.postgres;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import nl._42.boot.docker.postgres.DockerPostgresBootSequence;
import nl._42.boot.docker.postgres.DockerPostgresProperties;
import nl._42.boot.docker.postgres.DockerStartContainerCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.context.support.AbstractApplicationContext;

public class DockerPostgresBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(DockerPostgresBean.class);
    private final DockerPostgresProperties properties;
    private final DataSourceProperties dataSourceProperties;
    private DockerStartContainerCommand postgresContainer;
    @Autowired
    private AbstractApplicationContext applicationContext;

    public DockerPostgresBean(DockerPostgresProperties properties, DataSourceProperties dataSourceProperties) {
        this.properties = properties;
        this.dataSourceProperties = dataSourceProperties;
    }

    @PostConstruct
    public void postConstruct() throws Exception {
        LOGGER.info(">>> Configuring Docker Postgres");
        this.postgresContainer = new DockerPostgresBootSequence(this.properties, this.dataSourceProperties).execute();
        this.applicationContext.registerShutdownHook();
    }

    @PreDestroy
    public void preDestroy() {
        LOGGER.info(">>> Tearing down Postgres Docker");
        this.postgresContainer.interrupt();
    }
}

