/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.analyze;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import nl.basjes.parse.useragent.analyze.Matcher;

@DefaultSerializer(value=KryoSerializer.class)
public final class MatcherList
implements Collection<Matcher>,
Serializable {
    private int size;
    private int maxSize;
    private Matcher[] allElements;
    private static final int CAPACITY_INCREASE = 3;

    private MatcherList() {
    }

    public MatcherList(int newMaxSize) {
        this.maxSize = newMaxSize;
        this.initialize();
    }

    private void initialize() {
        this.size = 0;
        this.allElements = new Matcher[this.maxSize];
        for (int i = 0; i < this.maxSize; ++i) {
            this.allElements[i] = null;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean add(Matcher matcher) {
        if (this.size >= this.maxSize) {
            this.increaseCapacity();
        }
        this.allElements[this.size] = matcher;
        ++this.size;
        return true;
    }

    @Override
    public Iterator<Matcher> iterator() {
        return new Iterator<Matcher>(){
            int offset = 0;

            @Override
            public boolean hasNext() {
                return this.offset < MatcherList.this.size;
            }

            @Override
            public Matcher next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException("Array index out of bounds");
                }
                return MatcherList.this.allElements[this.offset++];
            }
        };
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.allElements, this.size);
    }

    private void increaseCapacity() {
        int newMaxSize = this.maxSize + 3;
        Matcher[] newAllElements = new Matcher[newMaxSize];
        System.arraycopy(this.allElements, 0, newAllElements, 0, this.maxSize);
        for (int i = this.maxSize; i < newMaxSize; ++i) {
            newAllElements[i] = null;
        }
        this.allElements = newAllElements;
        this.maxSize = newMaxSize;
    }

    @Override
    public boolean addAll(Collection<? extends Matcher> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] ts) {
        throw new UnsupportedOperationException();
    }

    public static class KryoSerializer
    extends FieldSerializer<MatcherList> {
        public KryoSerializer(Kryo kryo, Class type) {
            super(kryo, type);
        }

        public void write(Kryo kryo, Output output, MatcherList object) {
            output.write(object.maxSize);
        }

        public MatcherList read(Kryo kryo, Input input, Class<MatcherList> type) {
            MatcherList matcherList = new MatcherList();
            matcherList.maxSize = input.read();
            matcherList.initialize();
            return matcherList;
        }
    }
}

