/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent;

import nl.basjes.parse.useragent.Analyzer;
import nl.basjes.parse.useragent.PreHeatCases;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface AnalyzerPreHeater
extends Analyzer {
    public static final Logger LOG = LogManager.getLogger(AnalyzerPreHeater.class);
    public static final long MAX_PRE_HEAT_ITERATIONS = 1000000L;

    default public long preHeat() {
        return this.preHeat(PreHeatCases.USERAGENTS.size(), true);
    }

    default public long preHeat(long preheatIterations) {
        return this.preHeat(preheatIterations, true);
    }

    default public long preHeat(long preheatIterations, boolean log) {
        if (PreHeatCases.USERAGENTS.isEmpty()) {
            LOG.fatal("NO PREHEAT WAS DONE. This should never occur.");
            return 0L;
        }
        if (preheatIterations <= 0L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for {} to run.", (Object)preheatIterations);
            return 0L;
        }
        if (preheatIterations > 1000000L) {
            LOG.warn("NO PREHEAT WAS DONE. Simply because you asked for too many ({} > {}) to run.", (Object)preheatIterations, (Object)1000000L);
            return 0L;
        }
        if (log) {
            LOG.info("Preheating JVM by running {} testcases.", (Object)preheatIterations);
        }
        long remainingIterations = preheatIterations;
        long goodResults = 0L;
        block0: while (remainingIterations > 0L) {
            for (String userAgentString : PreHeatCases.USERAGENTS) {
                --remainingIterations;
                if (!this.parse(userAgentString).hasSyntaxError()) {
                    ++goodResults;
                }
                if (remainingIterations > 0L) continue;
                continue block0;
            }
        }
        if (log) {
            LOG.info("Preheating JVM completed. ({} of {} were proper results)", (Object)goodResults, (Object)preheatIterations);
        }
        return preheatIterations;
    }
}

