/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.parse.useragent.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StringTable {
    private List<String> headers = new ArrayList<String>();
    private List<List<String>> lines = new ArrayList<List<String>>();

    public String toString() {
        StringBuilder sb = new StringBuilder(512);
        ArrayList<Integer> columnWidths = new ArrayList<Integer>();
        for (int column = 0; column < this.headers.size(); ++column) {
            int maxWidth = this.headers.get(column).length();
            for (List<String> line : this.lines) {
                String columnValue;
                if (line.isEmpty() || line.size() <= column || (columnValue = line.get(column)) == null) continue;
                maxWidth = Math.max(maxWidth, columnValue.length());
            }
            columnWidths.add(maxWidth);
        }
        this.writeSeparator(sb, columnWidths);
        this.writeLine(sb, columnWidths, this.headers);
        this.writeSeparator(sb, columnWidths);
        for (List<String> line : this.lines) {
            this.writeLine(sb, columnWidths, line);
        }
        this.writeSeparator(sb, columnWidths);
        return sb.toString();
    }

    private void repeatedChar(StringBuilder sb, char charr, int length) {
        if (length <= 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            sb.append(charr);
        }
    }

    private void writeSeparator(StringBuilder sb, List<Integer> columnWidths) {
        boolean first = true;
        for (Integer columnWidth : columnWidths) {
            if (first) {
                sb.append('|');
                first = false;
            } else {
                sb.append('+');
            }
            this.repeatedChar(sb, '-', columnWidth + 2);
        }
        sb.append('|');
        sb.append('\n');
    }

    private void writeLine(StringBuilder sb, List<Integer> columnWidths, List<String> fields) {
        if (fields.isEmpty()) {
            this.writeSeparator(sb, columnWidths);
            return;
        }
        int columns = Math.max(columnWidths.size(), fields.size());
        for (int columnNr = 0; columnNr < columns; ++columnNr) {
            int columnWidth = 1;
            if (columnNr < columnWidths.size()) {
                columnWidth = columnWidths.get(columnNr);
            }
            if (columnNr <= columnWidths.size()) {
                sb.append('|');
            }
            String field = "";
            if (columnNr < fields.size()) {
                field = fields.get(columnNr);
            }
            sb.append(String.format(" %-" + columnWidth + "s ", field));
        }
        if (columns <= columnWidths.size()) {
            sb.append('|');
        }
        sb.append('\n');
    }

    public StringTable withHeaders(String ... fields) {
        this.headers = Arrays.asList(fields);
        return this;
    }

    public StringTable withHeaders(List<String> fields) {
        this.headers = new ArrayList<String>(fields);
        return this;
    }

    public StringTable addRow(String ... fields) {
        this.lines.add(Arrays.asList(fields));
        return this;
    }

    public StringTable addRow(List<String> fields) {
        this.lines.add(new ArrayList<String>(fields));
        return this;
    }

    public StringTable addRowSeparator() {
        this.lines.add(new ArrayList());
        return this;
    }
}

