/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier;

import java.util.List;
import nl.jqno.equalsverifier.ConfiguredEqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.api.MultipleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.api.RelaxedEqualsVerifierApi;
import nl.jqno.equalsverifier.api.SingleTypeEqualsVerifierApi;
import nl.jqno.equalsverifier.internal.reflection.PackageScanner;
import nl.jqno.equalsverifier.internal.util.ListBuilders;
import nl.jqno.equalsverifier.internal.util.Validations;

public final class EqualsVerifier {
    private EqualsVerifier() {
    }

    public static ConfiguredEqualsVerifier configure() {
        return new ConfiguredEqualsVerifier();
    }

    public static ConfiguredEqualsVerifier simple() {
        return new ConfiguredEqualsVerifier().suppress(Warning.STRICT_INHERITANCE, Warning.NONFINAL_FIELDS);
    }

    public static <T> SingleTypeEqualsVerifierApi<T> forClass(Class<T> type) {
        return new SingleTypeEqualsVerifierApi<T>(type);
    }

    public static MultipleTypeEqualsVerifierApi forClasses(Iterable<Class<?>> classes) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.fromIterable(classes), new ConfiguredEqualsVerifier());
    }

    public static MultipleTypeEqualsVerifierApi forClasses(Class<?> first, Class<?> second, Class<?> ... more) {
        return new MultipleTypeEqualsVerifierApi(ListBuilders.buildListOfAtLeastTwo(first, second, more), new ConfiguredEqualsVerifier());
    }

    public static MultipleTypeEqualsVerifierApi forPackage(String packageName) {
        return EqualsVerifier.forPackage(packageName, false);
    }

    public static MultipleTypeEqualsVerifierApi forPackage(String packageName, boolean scanRecursively) {
        List<Class<?>> classes = PackageScanner.getClassesIn(packageName, scanRecursively);
        Validations.validatePackageContainsClasses(packageName, classes);
        return new MultipleTypeEqualsVerifierApi(classes, new ConfiguredEqualsVerifier());
    }

    @SafeVarargs
    public static <T> RelaxedEqualsVerifierApi<T> forRelaxedEqualExamples(T first, T second, T ... more) {
        List<T> examples = ListBuilders.buildListOfAtLeastTwo(first, second, more);
        Class<?> type = first.getClass();
        return new RelaxedEqualsVerifierApi(type, examples);
    }
}

