/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Field;
import java.util.Set;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;

public class FieldInspector<T> {
    private final ClassAccessor<T> classAccessor;
    private final TypeTag typeTag;

    public FieldInspector(ClassAccessor<T> classAccessor, TypeTag typeTag) {
        this.classAccessor = classAccessor;
        this.typeTag = typeTag;
    }

    public void check(FieldCheck<T> check) {
        for (Field field : FieldIterable.of(this.classAccessor.getType())) {
            ObjectAccessor<T> reference = this.classAccessor.getRedAccessor(this.typeTag);
            ObjectAccessor<T> copy = this.classAccessor.getRedAccessor(this.typeTag);
            FieldAccessor fieldAccessor = FieldAccessor.of(field);
            check.execute(reference, copy, fieldAccessor);
        }
    }

    public void checkWithNull(Set<String> nonnullFields, AnnotationCache annotationCache, FieldCheck<T> check) {
        for (Field field : FieldIterable.of(this.classAccessor.getType())) {
            ObjectAccessor<T> reference = this.classAccessor.getDefaultValuesAccessor(this.typeTag, nonnullFields, annotationCache);
            ObjectAccessor<T> changed = this.classAccessor.getDefaultValuesAccessor(this.typeTag, nonnullFields, annotationCache);
            FieldAccessor fieldAccessor = FieldAccessor.of(field);
            check.execute(reference, changed, fieldAccessor);
        }
    }
}

