/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.checkers.Checker;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldIterable;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public class RecordChecker<T>
implements Checker {
    private final Configuration<T> config;

    public RecordChecker(Configuration<T> config) {
        this.config = config;
    }

    @Override
    public void check() {
        ClassAccessor<T> accessor = this.config.getClassAccessor();
        if (!accessor.isRecord()) {
            return;
        }
        this.verifyRecordPrecondition(accessor.getRedAccessor(this.config.getTypeTag()));
        this.verifyRecordPrecondition(accessor.getDefaultValuesAccessor(this.config.getTypeTag(), this.config.getNonnullFields(), this.config.getAnnotationCache()));
    }

    private void verifyRecordPrecondition(ObjectAccessor<T> originalAccessor) {
        T copy;
        Class<T> type = this.config.getType();
        T original = originalAccessor.get();
        if (original.equals(copy = originalAccessor.copy())) {
            return;
        }
        ArrayList<String> failedFields = new ArrayList<String>();
        for (Field f : FieldIterable.of(type)) {
            Method accessorMethod = this.getAccessorMethodFor(type, f);
            try {
                Object copyField;
                Object originalField = accessorMethod.invoke(original, new Object[0]);
                if (originalField.equals(copyField = accessorMethod.invoke(copy, new Object[0]))) continue;
                failedFields.add(f.getName());
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                Assert.fail(Formatter.of("Record: failed to invoke accessor method: " + accessorMethod, new Object[0]));
            }
        }
        Assert.fail(Formatter.of("Record invariant: constructor invariant failed for field%%: %%", failedFields.size() > 1 ? "s" : "", failedFields.stream().collect(Collectors.joining(","))));
    }

    private Method getAccessorMethodFor(Class<T> type, Field f) {
        return Rethrow.rethrow(() -> {
            Method result = type.getDeclaredMethod(f.getName(), new Class[0]);
            result.setAccessible(true);
            return result;
        });
    }
}

