/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import java.util.EnumSet;
import java.util.Set;
import nl.jqno.equalsverifier.Warning;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.ClassAccessor;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.NonnullAnnotationVerifier;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class ReflexivityFieldCheck<T>
implements FieldCheck<T> {
    private final TypeTag typeTag;
    private final PrefabValues prefabValues;
    private final EnumSet<Warning> warningsToSuppress;
    private final Set<String> nonnullFields;
    private final AnnotationCache annotationCache;

    public ReflexivityFieldCheck(Configuration<T> config) {
        this.typeTag = config.getTypeTag();
        this.prefabValues = config.getPrefabValues();
        this.warningsToSuppress = config.getWarningsToSuppress();
        this.nonnullFields = config.getNonnullFields();
        this.annotationCache = config.getAnnotationCache();
    }

    @Override
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY_FOR_VERSIONED_ENTITY)) {
            return;
        }
        this.checkReferenceReflexivity(referenceAccessor, copyAccessor);
        this.checkValueReflexivity(referenceAccessor, copyAccessor, fieldAccessor);
        this.checkNullReflexivity(referenceAccessor, copyAccessor, fieldAccessor);
    }

    private void checkReferenceReflexivity(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor) {
        T left = referenceAccessor.get();
        T right = copyAccessor.get();
        this.checkReflexivityFor(left, right);
    }

    private void checkValueReflexivity(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        Field field = fieldAccessor.getField();
        Class<?> fieldType = field.getType();
        if (this.warningsToSuppress.contains((Object)Warning.REFERENCE_EQUALITY)) {
            return;
        }
        if (fieldType.equals(Object.class) || fieldType.isInterface()) {
            return;
        }
        if (fieldAccessor.fieldIsStatic()) {
            return;
        }
        ClassAccessor<?> fieldTypeAccessor = ClassAccessor.of(fieldType, this.prefabValues);
        if (!fieldTypeAccessor.declaresEquals()) {
            return;
        }
        if (fieldType.isSynthetic()) {
            return;
        }
        TypeTag tag = TypeTag.of(field, this.typeTag);
        T left = referenceAccessor.withFieldSetTo(field, this.prefabValues.giveRed(tag)).get();
        T right = copyAccessor.withFieldSetTo(field, this.prefabValues.giveRedCopy(tag)).get();
        Formatter f = Formatter.of("Reflexivity: == used instead of .equals() on field: %%\nIf this is intentional, consider suppressing Warning.%%", field.getName(), Warning.REFERENCE_EQUALITY.toString());
        Assert.assertEquals(f, left, right);
    }

    private void checkNullReflexivity(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        boolean ignoreNull;
        Field field = fieldAccessor.getField();
        boolean fieldIsPrimitive = fieldAccessor.fieldIsPrimitive();
        boolean fieldIsNonNull = NonnullAnnotationVerifier.fieldIsNonnull(field, this.annotationCache);
        boolean bl = ignoreNull = fieldIsNonNull || this.warningsToSuppress.contains((Object)Warning.NULL_FIELDS) || this.nonnullFields.contains(field.getName());
        if (fieldIsPrimitive || !ignoreNull) {
            T left = referenceAccessor.withDefaultedField(field).get();
            T right = copyAccessor.withDefaultedField(field).get();
            this.checkReflexivityFor(left, right);
        }
    }

    private void checkReflexivityFor(T left, T right) {
        if (this.warningsToSuppress.contains((Object)Warning.IDENTICAL_COPY)) {
            Formatter f = Formatter.of("Unnecessary suppression: %%. Two identical copies are equal.", Warning.IDENTICAL_COPY.toString());
            Assert.assertFalse(f, left.equals(right));
        } else {
            Formatter f = Formatter.of("Reflexivity: object does not equal an identical copy of itself:\n  %%\nIf this is intentional, consider suppressing Warning.%%", left, Warning.IDENTICAL_COPY.toString());
            Assert.assertEquals(f, left, right);
        }
    }
}

