/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.checkers.fieldchecks;

import java.lang.reflect.Field;
import nl.jqno.equalsverifier.internal.checkers.fieldchecks.FieldCheck;
import nl.jqno.equalsverifier.internal.prefabvalues.PrefabValues;
import nl.jqno.equalsverifier.internal.prefabvalues.TypeTag;
import nl.jqno.equalsverifier.internal.reflection.FieldAccessor;
import nl.jqno.equalsverifier.internal.reflection.ObjectAccessor;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.SupportedAnnotations;
import nl.jqno.equalsverifier.internal.util.Assert;
import nl.jqno.equalsverifier.internal.util.Configuration;
import nl.jqno.equalsverifier.internal.util.Formatter;

public class TransientFieldsCheck<T>
implements FieldCheck<T> {
    private final PrefabValues prefabValues;
    private final TypeTag typeTag;
    private final AnnotationCache annotationCache;

    public TransientFieldsCheck(Configuration<T> config) {
        this.prefabValues = config.getPrefabValues();
        this.typeTag = config.getTypeTag();
        this.annotationCache = config.getAnnotationCache();
    }

    @Override
    public void execute(ObjectAccessor<T> referenceAccessor, ObjectAccessor<T> copyAccessor, FieldAccessor fieldAccessor) {
        boolean fieldIsTransient;
        T changed;
        Field field = fieldAccessor.getField();
        T reference = referenceAccessor.get();
        boolean equalsChanged = !reference.equals(changed = copyAccessor.withChangedField(field, this.prefabValues, this.typeTag).get());
        boolean hasAnnotation = this.annotationCache.hasFieldAnnotation(this.typeTag.getType(), field.getName(), SupportedAnnotations.TRANSIENT);
        boolean bl = fieldIsTransient = fieldAccessor.fieldIsTransient() || hasAnnotation;
        if (equalsChanged && fieldIsTransient) {
            Assert.fail(Formatter.of("Transient field %% should not be included in equals/hashCode contract.", field.getName()));
        }
        referenceAccessor.withChangedField(field, this.prefabValues, this.typeTag);
    }
}

