/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import nl.jqno.equalsverifier.internal.util.Rethrow;

public final class PackageScanner {
    private PackageScanner() {
    }

    public static List<Class<?>> getClassesIn(String packageName, boolean scanRecursively) {
        return PackageScanner.getDirs(packageName).stream().flatMap(d -> PackageScanner.getClassesInDir(packageName, d, scanRecursively).stream()).collect(Collectors.toList());
    }

    private static List<File> getDirs(String packageName) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        return Rethrow.rethrow(() -> Collections.list(cl.getResources(path)).stream().map(r -> new File(r.getFile())).collect(Collectors.toList()), "Could not scan package " + packageName);
    }

    private static List<Class<?>> getClassesInDir(String packageName, File dir, boolean scanRecursively) {
        if (!dir.exists()) {
            return Collections.emptyList();
        }
        return Arrays.stream(dir.listFiles()).filter(f -> scanRecursively && f.isDirectory() || f.getName().endsWith(".class")).flatMap(f -> {
            List<Class<?>> classes = f.isDirectory() ? PackageScanner.getClassesInDir(packageName + "." + f.getName(), f, scanRecursively) : Collections.singletonList(PackageScanner.fileToClass(packageName, f));
            return classes.stream();
        }).filter(c -> !c.isAnonymousClass()).filter(c -> !c.isLocalClass()).filter(c -> !c.getName().endsWith("Test")).collect(Collectors.toList());
    }

    private static Class<?> fileToClass(String packageName, File file) {
        String className = file.getName().substring(0, file.getName().length() - 6);
        return Rethrow.rethrow(() -> Class.forName(packageName + "." + className), "Could not resolve class " + className + ", which was found in package " + packageName);
    }
}

