/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.reflection.annotations;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.annotation.AnnotationDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.field.FieldDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.method.MethodList;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.description.type.TypeDescription;
import nl.jqno.equalsverifier.internal.lib.bytebuddy.pool.TypePool;
import nl.jqno.equalsverifier.internal.reflection.SuperclassIterable;
import nl.jqno.equalsverifier.internal.reflection.Util;
import nl.jqno.equalsverifier.internal.reflection.annotations.Annotation;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationCache;
import nl.jqno.equalsverifier.internal.reflection.annotations.AnnotationProperties;

public class AnnotationCacheBuilder {
    private final List<Annotation> supportedAnnotations;
    private final Set<String> ignoredAnnotations;

    public AnnotationCacheBuilder(Annotation[] supportedAnnotations, Set<String> ignoredAnnotations) {
        this.supportedAnnotations = Arrays.asList(supportedAnnotations);
        this.ignoredAnnotations = Collections.unmodifiableSet(ignoredAnnotations);
    }

    public void build(Class<?> type, AnnotationCache cache) {
        if (cache.hasResolved(type)) {
            return;
        }
        try {
            TypePool pool = TypePool.Default.of(type.getClassLoader());
            TypeDescription typeDescription = pool.describe(type.getName()).resolve();
            this.visitType(Util.setOf(type), cache, typeDescription, false);
            this.visitSuperclasses(type, cache, pool);
            this.visitOuterClasses(type, cache, pool);
            this.visitPackage(type, cache, pool);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void visitType(Set<Class<?>> types, AnnotationCache cache, TypeDescription typeDescription, boolean inheriting) {
        this.visitClass(types, cache, typeDescription, inheriting);
        this.visitFields(types, cache, typeDescription, inheriting);
    }

    private void visitSuperclasses(Class<?> type, AnnotationCache cache, TypePool pool) {
        for (Class<?> c : SuperclassIterable.of(type)) {
            TypeDescription typeDescription = pool.describe(c.getName()).resolve();
            this.visitType(Util.setOf(type, c), cache, typeDescription, true);
        }
    }

    private void visitOuterClasses(Class<?> type, AnnotationCache cache, TypePool pool) {
        for (Class<?> outer = type.getDeclaringClass(); outer != null; outer = outer.getDeclaringClass()) {
            TypeDescription typeDescription = pool.describe(outer.getName()).resolve();
            this.visitType(Util.setOf(type, outer), cache, typeDescription, false);
        }
    }

    private void visitPackage(Class<?> type, AnnotationCache cache, TypePool pool) {
        Package pkg = type.getPackage();
        if (pkg == null) {
            return;
        }
        String className = pkg.getName() + ".package-info";
        try {
            TypeDescription typeDescription = pool.describe(className).resolve();
            this.visitType(Util.setOf(type), cache, typeDescription, false);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void visitClass(Set<Class<?>> types, AnnotationCache cache, TypeDescription typeDescription, boolean inheriting) {
        Consumer<Annotation> addToCache = a -> types.forEach(t -> cache.addClassAnnotation((Class<?>)t, (Annotation)a));
        typeDescription.getDeclaredAnnotations().forEach(a -> this.cacheSupportedAnnotations((AnnotationDescription)a, types, cache, addToCache, inheriting));
    }

    private void visitFields(Set<Class<?>> types, AnnotationCache cache, TypeDescription typeDescription, boolean inheriting) {
        for (FieldDescription.InDefinedShape f : typeDescription.getDeclaredFields()) {
            Consumer<Annotation> addToCache = a -> types.forEach(t -> cache.addFieldAnnotation((Class<?>)t, f.getName(), (Annotation)a));
            for (AnnotationDescription a2 : f.getDeclaredAnnotations()) {
                this.cacheSupportedAnnotations(a2, types, cache, addToCache, inheriting);
            }
            for (AnnotationDescription a2 : f.getType().getDeclaredAnnotations()) {
                this.cacheSupportedAnnotations(a2, types, cache, addToCache, inheriting);
            }
        }
        MethodList methods = (MethodList)typeDescription.getDeclaredMethods().filter(m -> m.getName().startsWith("get") && m.getName().length() > 3);
        for (MethodDescription.InDefinedShape m2 : methods) {
            String methodName = m2.getName();
            String correspondingFieldName = Character.toLowerCase(methodName.charAt(3)) + methodName.substring(4);
            Consumer<Annotation> addToCache = a -> types.forEach(t -> cache.addFieldAnnotation((Class<?>)t, correspondingFieldName, (Annotation)a));
            for (AnnotationDescription a3 : m2.getDeclaredAnnotations()) {
                this.cacheSupportedAnnotations(a3, types, cache, addToCache, inheriting);
            }
        }
    }

    private void cacheSupportedAnnotations(AnnotationDescription annotation, Set<Class<?>> types, AnnotationCache cache, Consumer<Annotation> addToCache, boolean inheriting) {
        if (this.ignoredAnnotations.contains(annotation.getAnnotationType().getCanonicalName())) {
            return;
        }
        Consumer<Annotation> postProcess = a -> a.postProcess(types, cache);
        AnnotationProperties props = this.buildAnnotationProperties(annotation);
        this.supportedAnnotations.stream().filter(sa -> this.matches(annotation, (Annotation)sa)).filter(sa -> !inheriting || sa.inherits()).filter(sa -> sa.validate(props, cache, this.ignoredAnnotations)).forEach(addToCache.andThen(postProcess));
    }

    private AnnotationProperties buildAnnotationProperties(AnnotationDescription annotation) {
        AnnotationProperties props = new AnnotationProperties(annotation.getAnnotationType().getCanonicalName());
        for (MethodDescription.InDefinedShape m : annotation.getAnnotationType().getDeclaredMethods()) {
            Object val = annotation.getValue(m).resolve();
            if (!val.getClass().isArray() || val.getClass().getComponentType().isPrimitive()) continue;
            Object[] array = (Object[])val;
            HashSet<String> values = new HashSet<String>();
            for (Object obj : array) {
                if (obj instanceof TypeDescription) {
                    values.add(((TypeDescription)obj).getName());
                    continue;
                }
                values.add(obj.toString());
            }
            props.putArrayValues(m.getName(), values);
        }
        return props;
    }

    private boolean matches(AnnotationDescription foundAnnotation, Annotation supportedAnnotation) {
        String canonicalName = foundAnnotation.getAnnotationType().getCanonicalName();
        if (canonicalName == null) {
            return false;
        }
        return supportedAnnotation.partialClassNames().stream().anyMatch(canonicalName::endsWith);
    }
}

