/*
 * Decompiled with CFR 0.152.
 */
package nl.jqno.equalsverifier.internal.util;

import nl.jqno.equalsverifier.internal.exceptions.EqualsVerifierInternalBugException;
import nl.jqno.equalsverifier.internal.exceptions.ReflectionException;

public final class Rethrow {
    private Rethrow() {
    }

    public static <T> T rethrow(ThrowingSupplier<T> supplier, String errorMessage) {
        try {
            return supplier.get();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (ReflectiveOperationException e) {
            throw new ReflectionException(Rethrow.msg(errorMessage, e), e);
        }
        catch (Exception e) {
            throw new EqualsVerifierInternalBugException(Rethrow.msg(errorMessage, e), e);
        }
    }

    public static <T> T rethrow(ThrowingSupplier<T> supplier) {
        return Rethrow.rethrow(supplier, null);
    }

    public static void rethrow(ThrowingRunnable block, String errorMessage) {
        Rethrow.rethrow(() -> {
            block.run();
            return null;
        }, errorMessage);
    }

    public static void rethrow(ThrowingRunnable block) {
        Rethrow.rethrow(block, null);
    }

    private static String msg(String errorMessage, Throwable e) {
        return errorMessage != null ? errorMessage : e.getMessage();
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T> {
        public T get() throws Exception;
    }

    @FunctionalInterface
    public static interface ThrowingRunnable {
        public void run() throws Exception;
    }
}

