/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Hexagon;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondWIP;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public class FtileDiamondSquare
extends FtileDiamondWIP {
    public FtileDiamondSquare(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane) {
        this(label, skinParam, backColor, borderColor, swimlane, TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0));
    }

    public FtileDiamondSquare withNorth(TextBlock north) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, north, this.west, this.east, this.south);
    }

    public FtileDiamondSquare withWest(TextBlock west) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, west, this.east, this.south);
    }

    public FtileDiamondSquare withEast(TextBlock east) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.west, east, this.south);
    }

    public FtileDiamondSquare withSouth(TextBlock south) {
        return new FtileDiamondSquare(this.label, this.skinParam(), this.backColor, this.borderColor, this.swimlane, this.north, this.west, this.east, south);
    }

    public Ftile withWestAndEast(TextBlock tb1, TextBlock tb2) {
        return this.withWest(tb1).withEast(tb2);
    }

    private FtileDiamondSquare(TextBlock label, ISkinParam skinParam, HColor backColor, HColor borderColor, Swimlane swimlane, TextBlock north, TextBlock west, TextBlock east, TextBlock south) {
        super(label, skinParam, backColor, borderColor, swimlane, north, south, east, west);
    }

    @Override
    public void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        Dimension2D dimTotal = this.calculateDimensionInternal(stringBounder);
        ug = ug.apply(this.borderColor).apply(this.getThickness()).apply(this.backColor.bg());
        ug.draw(Hexagon.asPolygonSquare(this.skinParam().shadowing(null), dimTotal.getWidth(), dimTotal.getHeight()));
        this.north.drawU(ug.apply(new UTranslate(4.0 + dimTotal.getWidth() / 2.0, dimTotal.getHeight())));
        this.south.drawU(ug.apply(new UTranslate(4.0 + dimTotal.getWidth() / 2.0, dimTotal.getHeight())));
        double lx = (dimTotal.getWidth() - dimLabel.getWidth()) / 2.0;
        double ly = (dimTotal.getHeight() - dimLabel.getHeight()) / 2.0;
        this.label.drawU(ug.apply(new UTranslate(lx, ly)));
        Dimension2D dimWeat = this.west.calculateDimension(stringBounder);
        this.west.drawU(ug.apply(new UTranslate(-dimWeat.getWidth(), -dimWeat.getHeight() + 12.0)));
        Dimension2D dimEast = this.east.calculateDimension(stringBounder);
        this.east.drawU(ug.apply(new UTranslate(dimTotal.getWidth(), -dimEast.getHeight() + 12.0)));
    }

    @Override
    protected FtileGeometry calculateDimensionFtile(StringBounder stringBounder) {
        Dimension2D dim = this.calculateDimensionInternal(stringBounder);
        return new FtileGeometry(dim, dim.getWidth() / 2.0, 0.0, dim.getHeight());
    }

    private Dimension2D calculateDimensionInternal(StringBounder stringBounder) {
        Dimension2D dimLabel = this.label.calculateDimension(stringBounder);
        if (dimLabel.getWidth() == 0.0 || dimLabel.getHeight() == 0.0) {
            return new Dimension2DDouble(24.0, 24.0);
        }
        Dimension2D result = dimLabel;
        result = Dimension2DDouble.delta(result, 24.0, 24.0);
        return result;
    }
}

