/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineConfigurable;
import net.sourceforge.plantuml.SkinParamUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.creole.CreoleMode;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.color.ColorType;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignature;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.color.HColor;

public abstract class EntityImageStateCommon
extends AbstractEntityImage {
    protected final TextBlock desc;
    protected final Url url;
    protected final LineConfigurable lineConfig;

    public EntityImageStateCommon(IEntity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        this.lineConfig = entity;
        Stereotype stereotype = entity.getStereotype();
        FontConfiguration fontConfiguration = UseStyle.useBetaStyle() ? this.getStyleStateHeader().getFontConfiguration(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : new FontConfiguration(this.getSkinParam(), FontParam.STATE, stereotype);
        this.desc = entity.getDisplay().create8(fontConfiguration, HorizontalAlignment.CENTER, skinParam, CreoleMode.FULL, skinParam.wrapWidth());
        this.url = entity.getUrl99();
    }

    private Style getStyleStateHeader() {
        return StyleSignature.of(SName.root, SName.element, SName.stateDiagram, SName.state, SName.header).with(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    protected final Style getStyleState() {
        return StyleSignature.of(SName.root, SName.element, SName.stateDiagram, SName.state).with(this.getEntity().getStereotype()).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    protected final UStroke getStroke() {
        UStroke stroke = this.lineConfig.getColors(this.getSkinParam()).getSpecificLineStroke();
        if (stroke == null) {
            stroke = new UStroke(1.5);
        }
        return stroke;
    }

    @Override
    public final ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    protected final URectangle getShape(Dimension2D dimTotal) {
        double corner;
        double deltaShadow = 0.0;
        if (UseStyle.useBetaStyle()) {
            corner = this.getStyleState().value(PName.RoundCorner).asDouble();
            deltaShadow = this.getStyleState().value(PName.Shadowing).asDouble();
        } else {
            corner = 25.0;
            if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
                deltaShadow = 4.0;
            }
        }
        URectangle rect = new URectangle(dimTotal).rounded(corner);
        rect.setDeltaShadow(deltaShadow);
        return rect;
    }

    protected final UGraphic applyColor(UGraphic ug) {
        HColor classBorder = this.lineConfig.getColors(this.getSkinParam()).getColor(ColorType.LINE);
        if (classBorder == null) {
            classBorder = UseStyle.useBetaStyle() ? this.getStyleState().value(PName.LineColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBorder);
        }
        ug = ug.apply(this.getStroke()).apply(classBorder);
        HColor backcolor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = UseStyle.useBetaStyle() ? this.getStyleState().value(PName.BackGroundColor).asColor(this.getSkinParam().getThemeStyle(), this.getSkinParam().getIHtmlColorSet()) : SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.stateBackground);
        }
        ug = ug.apply(backcolor.bg());
        return ug;
    }
}

