/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.javadoc;

import java.util.Collections;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.SimpleTypeVisitor9;
import nl.talsmasoftware.umldoclet.uml.TypeName;

final class TypeNameVisitor
extends SimpleTypeVisitor9<TypeName, Void> {
    private static final EnumSet<TypeKind> NO_KNOWN_TYPES = EnumSet.of(TypeKind.VOID, TypeKind.NONE, TypeKind.NULL, TypeKind.ERROR, TypeKind.OTHER);
    static final TypeNameVisitor INSTANCE = new TypeNameVisitor();
    private static ThreadLocal<Set<TypeMirror>> VISITED = ThreadLocal.withInitial(() -> Collections.newSetFromMap(new IdentityHashMap()));

    private TypeNameVisitor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TypeName _visit(TypeMirror type, Void parameter) {
        if (VISITED.get().add(type)) {
            try {
                TypeName typeName = (TypeName)super.visit(type, parameter);
                return typeName;
            }
            finally {
                VISITED.get().remove(type);
                if (VISITED.get().isEmpty()) {
                    VISITED.remove();
                }
            }
        }
        return this.defaultAction(type, parameter);
    }

    @Override
    public TypeName visitPrimitive(PrimitiveType primitiveType, Void parameter) {
        String primitive = primitiveType.getKind().name().toLowerCase();
        return new TypeName(primitive, primitive, new TypeName[0]);
    }

    @Override
    public TypeName visitNoType(NoType noType, Void parameter) {
        String none = noType.getKind().name().toLowerCase();
        return new TypeName(none, none, new TypeName[0]);
    }

    @Override
    public TypeName visitDeclared(DeclaredType declaredType, Void parameter) {
        Element el = declaredType.asElement();
        String simpleName = el.getSimpleName().toString();
        String qualifiedName = el instanceof QualifiedNameable ? ((QualifiedNameable)el).getQualifiedName().toString() : simpleName;
        TypeName[] generics = (TypeName[])declaredType.getTypeArguments().stream().map(generic -> this._visit((TypeMirror)generic, parameter)).toArray(TypeName[]::new);
        return new TypeName(simpleName, qualifiedName, generics);
    }

    @Override
    public TypeName visitArray(ArrayType arrayType, Void parameter) {
        return TypeName.Array.of(this._visit(arrayType.getComponentType(), parameter));
    }

    @Override
    public TypeName visitTypeVariable(TypeVariable typeVariable, Void parameter) {
        TypeMirror lowerBound;
        TypeMirror upperBound = typeVariable.getUpperBound();
        if (upperBound != null && !NO_KNOWN_TYPES.contains((Object)upperBound.getKind())) {
            TypeName upperBoundName = this._visit(upperBound, parameter);
            if (!Object.class.getName().equals(upperBoundName.qualified)) {
                return TypeName.Variable.extendsBound(typeVariable.toString(), upperBoundName);
            }
        }
        if ((lowerBound = typeVariable.getLowerBound()) != null && !NO_KNOWN_TYPES.contains((Object)lowerBound.getKind())) {
            return TypeName.Variable.superBound(typeVariable.toString(), this._visit(lowerBound, parameter));
        }
        return this.defaultAction((TypeMirror)typeVariable, parameter);
    }

    @Override
    public TypeName visitWildcard(WildcardType wildcardType, Void parameter) {
        TypeMirror extendsBound = wildcardType.getExtendsBound();
        if (extendsBound != null) {
            return TypeName.Variable.extendsBound("?", this._visit(extendsBound, parameter));
        }
        TypeMirror superBound = wildcardType.getSuperBound();
        if (superBound != null) {
            return TypeName.Variable.superBound("?", this._visit(superBound, parameter));
        }
        return this.defaultAction((TypeMirror)wildcardType, parameter);
    }

    @Override
    protected TypeName defaultAction(TypeMirror tp, Void parameter) {
        String qualified = tp.toString();
        int lt = qualified.lastIndexOf(60);
        int dot = (lt < 0 ? qualified : qualified.substring(0, lt)).lastIndexOf(46);
        return new TypeName(qualified.substring(dot + 1), qualified, new TypeName[0]);
    }
}

