/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import nl.talsmasoftware.umldoclet.configuration.Configuration;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Diagram;
import nl.talsmasoftware.umldoclet.uml.Link;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.Reference;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class DependencyDiagram
extends Diagram {
    private String pumlFileName;
    private File pumlFile = null;

    public DependencyDiagram(Configuration config, String pumlFileName) {
        super(config);
        this.pumlFileName = pumlFileName;
    }

    @Override
    public List<UMLNode> getChildren() {
        List<UMLNode> children = super.getChildren();
        List exclusionFiltered = children.stream().filter(this::isIncludedChild).collect(Collectors.toList());
        return exclusionFiltered.isEmpty() ? children : exclusionFiltered;
    }

    public void addPackageDependency(String fromPackage, String toPackage) {
        if (fromPackage != null && toPackage != null) {
            this.addChild(new Reference(Reference.Side.from(DependencyDiagram.unnamedIfEmpty(fromPackage), null), "-->", Reference.Side.to(DependencyDiagram.unnamedIfEmpty(toPackage), null), new String[0]));
        }
    }

    private boolean isExcludedPackage(String toPackage) {
        return this.getConfiguration().excludedPackageDependencies().stream().anyMatch(excluded -> excluded.equals(toPackage) || toPackage.startsWith(DependencyDiagram.dotSuffixed(excluded)) || "unnamed".equals(excluded) && toPackage.isEmpty());
    }

    private boolean isIncludedChild(UMLNode child) {
        return child instanceof Reference && !this.isExcludedPackage(((Reference)child).to.toString());
    }

    @Override
    protected File getPlantUmlFile() {
        if (this.pumlFile == null) {
            StringBuilder result = new StringBuilder(this.getConfiguration().destinationDirectory());
            if (result.length() > 0 && result.charAt(result.length() - 1) != '/') {
                result.append('/');
            }
            result.append(this.pumlFileName);
            this.pumlFile = new File(result.toString());
        }
        return this.pumlFile;
    }

    protected IndentingPrintWriter writeChildrenTo(IndentingPrintWriter output) {
        output.append("set namespaceSeparator none").newline().append("hide circle").newline().append("hide empty fields").newline().append("hide empty methods").newline().newline();
        super.writeChildrenTo(output);
        this.writePackageLinksTo(output.newline());
        return output;
    }

    private IndentingPrintWriter writePackageLinksTo(IndentingPrintWriter output) {
        output.println("' Package links");
        this.getChildren(Reference.class).stream().flatMap(reference -> Stream.of(reference.from.toString(), reference.to.toString())).distinct().map(packageName -> new Namespace(this, (String)packageName)).forEach(namespace -> this.writePackageLinkTo(output, (Namespace)namespace));
        return output;
    }

    private IndentingPrintWriter writePackageLinkTo(IndentingPrintWriter output, Namespace namespace) {
        String link = Link.forPackage(namespace).toString().trim();
        if (!link.isEmpty()) {
            output.append("class \"").append(namespace.name).append("\" ").append(link).append(" {\n}\n");
        }
        return output;
    }

    private static String unnamedIfEmpty(String packageName) {
        return packageName.isEmpty() ? "unnamed" : packageName;
    }

    private static String dotSuffixed(String packageName) {
        return packageName.endsWith(".") ? packageName : packageName + ".";
    }
}

