/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.io.File;
import java.net.URI;
import java.util.Objects;
import java.util.Optional;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.Type;
import nl.talsmasoftware.umldoclet.uml.UMLNode;
import nl.talsmasoftware.umldoclet.util.FileUtils;

public class Link
extends UMLNode {
    private static final ThreadLocal<String> LINK_FROM = new ThreadLocal();
    private final URI target;

    private Link(UMLNode parent, URI target) {
        super(parent);
        this.target = target;
    }

    public static Link forType(Type type) {
        String destinationDirectory = type.getConfiguration().destinationDirectory();
        String packageName = type.getPackagename();
        String nameInPackage = type.getName().qualified.startsWith(packageName + ".") ? type.getName().qualified.substring(packageName.length() + 1) : type.getName().simple;
        Optional<URI> target = Link.relativeHtmlFile(destinationDirectory, packageName, nameInPackage).or(() -> type.getConfiguration().resolveExternalLinkToType(packageName, nameInPackage));
        return new Link(type, target.orElse(null));
    }

    public static Link forPackage(Namespace namespace) {
        String destinationDirectory = namespace.getConfiguration().destinationDirectory();
        String packageName = namespace.name;
        String nameInPackage = "package-summary";
        Optional<URI> target = Link.relativeHtmlFile(destinationDirectory, packageName, "package-summary").or(() -> namespace.getConfiguration().resolveExternalLinkToType(packageName, "package-summary"));
        return new Link(namespace, target.orElse(null));
    }

    private static Optional<URI> relativeHtmlFile(String destinationDirectory, String packageName, String nameInPackage) {
        String directory = destinationDirectory + "/" + packageName.replace('.', '/');
        return Optional.of(new File(directory, nameInPackage + ".html")).filter(File::isFile).map(File::toURI);
    }

    public static boolean linkFrom(String basePath) {
        if (Objects.equals(basePath, LINK_FROM.get())) {
            return false;
        }
        if (basePath == null) {
            LINK_FROM.remove();
        } else {
            LINK_FROM.set(basePath);
        }
        return true;
    }

    private Optional<File> linkFromDir() {
        File fromDir;
        String dir = LINK_FROM.get();
        if (dir == null) {
            dir = this.getConfiguration().destinationDirectory();
        }
        return (fromDir = new File(dir)).isDirectory() ? Optional.of(fromDir) : Optional.empty();
    }

    private Optional<String> relativeTarget() {
        return Optional.ofNullable(this.target).filter(uri -> "file".equals(uri.getScheme())).map(File::new).flatMap(targetFile -> this.linkFromDir().map(dir -> FileUtils.relativePath(dir, targetFile)));
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        if (this.target != null) {
            output.append("[[").append(this.relativeTarget().orElseGet(this.target::toASCIIString)).append("]]");
        }
        return output;
    }
}

