/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.AlignmentParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.awt.geom.XDimension2D;
import net.sourceforge.plantuml.command.Position;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizVersion;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.USymbols;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotMode;
import net.sourceforge.plantuml.svek.SvekLine;
import net.sourceforge.plantuml.svek.SvekNode;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.svek.image.EntityImageNoteLink;

public class ClusterDotStringKermor {
    private final Cluster cluster;
    private final ISkinParam skinParam;
    private static final String ID_EE = "ee";

    public ClusterDotStringKermor(Cluster cluster, ISkinParam skinParam) {
        this.cluster = cluster;
        this.skinParam = skinParam;
    }

    void printInternal(StringBuilder sb, Collection<SvekLine> lines, StringBounder stringBounder, DotMode dotMode, GraphvizVersion graphvizVersion, UmlDiagramType type) {
        String label;
        StringBuilder sblabel;
        XDimension2D dim;
        boolean useAlphaAndBeta;
        Set<EntityPosition> entityPositionsExceptNormal = this.entityPositionsExceptNormal();
        if (entityPositionsExceptNormal.size() > 0) {
            for (SvekLine line : lines) {
                if (!line.isLinkFromOrTo(this.cluster.getGroup())) continue;
                line.setProjectionCluster(this.cluster);
            }
        }
        if (useAlphaAndBeta = this.useAlphaAndBeta()) {
            sb.append("subgraph " + this.cluster.getClusterId() + "alpha {");
            SvekUtils.println(sb);
            sb.append("color=\"#FFFF00\";");
            SvekUtils.println(sb);
            EntityImageNoteLink noteTop = this.cluster.getCucaNote(Position.TOP);
            if (noteTop == null) {
                sb.append("label=\"\";");
                SvekUtils.println(sb);
            } else {
                dim = noteTop.calculateDimension(stringBounder);
                sblabel = new StringBuilder("<");
                SvekLine.appendTable(sblabel, (int)dim.getWidth(), (int)dim.getHeight(), this.cluster.getColorNoteTop());
                sblabel.append(">");
                sb.append("label=" + sblabel + ";");
                SvekUtils.println(sb);
            }
        }
        SvekUtils.println(sb);
        sb.append("subgraph " + this.cluster.getClusterId() + "beta {");
        SvekUtils.println(sb);
        EntityImageNoteLink noteBottom = this.cluster.getCucaNote(Position.BOTTOM);
        sb.append("labelloc=\"b\";");
        SvekUtils.println(sb);
        sb.append("color=\"#FFFF00\";");
        SvekUtils.println(sb);
        if (noteBottom == null) {
            sb.append("label=\"\";");
            SvekUtils.println(sb);
        } else {
            dim = noteBottom.calculateDimension(stringBounder);
            sblabel = new StringBuilder("<");
            SvekLine.appendTable(sblabel, (int)dim.getWidth(), (int)dim.getHeight(), this.cluster.getColorNoteBottom());
            sblabel.append(">");
            sb.append("label=" + sblabel + ";");
            SvekUtils.println(sb);
        }
        SvekUtils.println(sb);
        this.printRanks("source", this.cluster.getNodes(EntityPosition.getInputs()), sb, stringBounder);
        SvekUtils.println(sb);
        sb.append("subgraph " + this.cluster.getClusterId() + "gamma {");
        SvekUtils.println(sb);
        sb.append("labelloc=\"t\";");
        SvekUtils.println(sb);
        sb.append("style=solid;");
        SvekUtils.println(sb);
        sb.append("color=\"" + StringUtils.sharp000000(this.cluster.getColor()) + "\";");
        if (this.cluster.isLabel()) {
            sblabel = new StringBuilder("<");
            SvekLine.appendTable(sblabel, this.cluster.getTitleAndAttributeWidth(), this.cluster.getTitleAndAttributeHeight() - 5, this.cluster.getTitleColor());
            sblabel.append(">");
            label = sblabel.toString();
            HorizontalAlignment align = this.skinParam.getHorizontalAlignment(AlignmentParam.packageTitleAlignment, null, false, null);
            sb.append("labeljust=\"" + align.getGraphVizValue() + "\";");
        } else {
            label = "\"\"";
        }
        sb.append("label=" + label + ";");
        SvekUtils.println(sb);
        this.cluster.printCluster3_forKermor(sb, lines, stringBounder, dotMode, graphvizVersion, type);
        SvekUtils.println(sb);
        this.printRanks("sink", this.cluster.getNodes(EntityPosition.getOutputs()), sb, stringBounder);
        SvekUtils.println(sb);
        sb.append("}");
        sb.append("}");
        if (useAlphaAndBeta) {
            sb.append("}");
        }
        SvekUtils.println(sb);
    }

    private boolean useAlphaAndBeta() {
        if (this.cluster.getGroup().getNotes(Position.TOP).size() > 0) {
            return true;
        }
        return this.cluster.getGroup().getNotes(Position.BOTTOM).size() > 0;
    }

    private String getSourceInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sourceIn" + this.cluster.getColor();
        }
        return null;
    }

    private String getSinkInPoint(UmlDiagramType type) {
        if (this.skinParam.useSwimlanes(type)) {
            return "sinkIn" + this.cluster.getColor();
        }
        return null;
    }

    private String empty() {
        return Cluster.getSpecialPointId(this.cluster.getGroup());
    }

    private boolean hasPort() {
        for (EntityPosition pos : this.entityPositionsExceptNormal()) {
            if (!pos.isPort()) continue;
            return true;
        }
        return false;
    }

    private Set<EntityPosition> entityPositionsExceptNormal() {
        EnumSet<EntityPosition> result = EnumSet.noneOf(EntityPosition.class);
        for (SvekNode sh : this.cluster.getNodes()) {
            if (sh.getEntityPosition() == EntityPosition.NORMAL) continue;
            result.add(sh.getEntityPosition());
        }
        return Collections.unmodifiableSet(result);
    }

    private void subgraphClusterNoLabel(StringBuilder sb, String id) {
        this.subgraphClusterWithLabel(sb, id, "\"\"");
    }

    private void subgraphClusterWithLabel(StringBuilder sb, String id, String label) {
        sb.append("subgraph " + this.cluster.getClusterId() + id + " {");
        sb.append("label=" + label + ";");
    }

    private void printRanks(String rank, List<? extends SvekNode> entries, StringBuilder sb, StringBounder stringBounder) {
        if (entries.size() > 0) {
            sb.append("{rank=" + rank + ";");
            for (SvekNode svekNode : entries) {
                sb.append(svekNode.getUid() + ";");
            }
            sb.append("}");
            SvekUtils.println(sb);
            for (SvekNode svekNode : entries) {
                svekNode.appendShape(sb, stringBounder);
            }
            SvekUtils.println(sb);
        }
    }

    private boolean protection0(UmlDiagramType type) {
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean protection1(UmlDiagramType type) {
        if (this.cluster.getGroup().getUSymbol() == USymbols.NODE) {
            return true;
        }
        return !this.skinParam.useSwimlanes(type);
    }

    private boolean isThereALinkFromOrToGroup(Collection<SvekLine> lines) {
        for (SvekLine line : lines) {
            if (!line.isLinkFromOrTo(this.cluster.getGroup())) continue;
            return true;
        }
        return false;
    }
}

