/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek.image;

import net.sourceforge.plantuml.awt.geom.XPoint2D;
import net.sourceforge.plantuml.ugraphic.UEllipse;

public class RotatedEllipse {
    private final UEllipse ellipse;
    private final double beta;

    public RotatedEllipse(UEllipse ellipse, double beta) {
        this.ellipse = ellipse;
        this.beta = beta;
    }

    public double getA() {
        return this.ellipse.getWidth() / 2.0;
    }

    public double getB() {
        return this.ellipse.getHeight() / 2.0;
    }

    public double getBeta() {
        return this.beta;
    }

    public XPoint2D getPoint(double theta) {
        double x = this.getA() * Math.cos(theta);
        double y = this.getB() * Math.sin(theta);
        double xp = x * Math.cos(this.beta) - y * Math.sin(this.beta);
        double yp = x * Math.sin(this.beta) + y * Math.cos(this.beta);
        return new XPoint2D(xp, yp);
    }

    public double getOtherTheta(double theta1) {
        double z = this.getPoint(theta1).getX();
        double a = this.getA() * Math.cos(this.beta);
        double b = this.getB() * Math.sin(this.beta);
        double sum = 2.0 * a * z / (a * a + b * b);
        double other = sum - Math.cos(theta1);
        return -Math.acos(other);
    }

    private double other(double[] all, double some) {
        double diff1;
        double diff0 = Math.abs(some - all[0]);
        if (diff0 > (diff1 = Math.abs(some - all[1]))) {
            return all[0];
        }
        return all[1];
    }
}

