/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.color;

import java.awt.Color;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.ugraphic.UBackground;
import net.sourceforge.plantuml.ugraphic.UChange;
import net.sourceforge.plantuml.ugraphic.color.ColorMapper;

public abstract class HColor
implements UChange {
    public UBackground bg() {
        return new UBackground(){

            @Override
            public HColor getBackColor() {
                return HColor.this;
            }
        };
    }

    public Color toColor(ColorMapper mapper) {
        throw new UnsupportedOperationException();
    }

    public final String toRGB(ColorMapper mapper) {
        Color color = this.toColor(mapper);
        return StringUtils.sharp000000(color.getRGB());
    }

    public final String toSvg(ColorMapper mapper) {
        if (this.isTransparent()) {
            return "#00000000";
        }
        Color color = this.toColor(mapper);
        int alpha = color.getAlpha();
        if (alpha == 255) {
            return this.toRGB(mapper);
        }
        Object s = "0" + Integer.toHexString(alpha).toUpperCase();
        s = ((String)s).substring(((String)s).length() - 2);
        return this.toRGB(mapper) + (String)s;
    }

    public HColor lighten(int ratio) {
        return this;
    }

    public HColor darken(int ratio) {
        return this;
    }

    public HColor reverseHsluv() {
        return this;
    }

    public HColor reverse() {
        return this;
    }

    public boolean isDark() {
        return true;
    }

    public String asString() {
        return "?" + this.getClass().getSimpleName();
    }

    public HColor darkSchemeTheme() {
        return this;
    }

    public HColor getAppropriateColor(HColor back) {
        return this;
    }

    public HColor withDark(HColor dark) {
        throw new UnsupportedOperationException();
    }

    public HColor opposite() {
        throw new UnsupportedOperationException();
    }

    public boolean isTransparent() {
        return false;
    }
}

