/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.util.Objects;
import java.util.Optional;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class Namespace
extends UMLNode {
    private final String moduleName;
    public final String name;

    public Namespace(UMLNode parent, String name, String moduleName) {
        super(parent);
        this.name = Objects.requireNonNull(name, "Package name is <null>.").trim();
        this.moduleName = moduleName;
    }

    public Optional<String> getModuleName() {
        return Optional.ofNullable(this.moduleName);
    }

    private <IPW extends IndentingPrintWriter> IPW writeNameTo(IPW output) {
        output.append(this.name.isEmpty() ? "unnamed" : this.name).whitespace();
        return output;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        this.writeNameTo(output.append("namespace").whitespace()).append('{').newline();
        this.writeChildrenTo(output.indent());
        output.append('}').newline();
        return output;
    }

    public boolean contains(TypeName typeName) {
        return typeName != null && typeName.qualified.startsWith(this.name + ".");
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Namespace && this.name.equals(((Namespace)other).name);
    }
}

