/*
 * Decompiled with CFR 0.152.
 */
package nl.talsmasoftware.umldoclet.uml;

import java.util.Collection;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import nl.talsmasoftware.umldoclet.configuration.TypeDisplay;
import nl.talsmasoftware.umldoclet.rendering.indent.IndentingPrintWriter;
import nl.talsmasoftware.umldoclet.uml.Link;
import nl.talsmasoftware.umldoclet.uml.Namespace;
import nl.talsmasoftware.umldoclet.uml.TypeMember;
import nl.talsmasoftware.umldoclet.uml.TypeName;
import nl.talsmasoftware.umldoclet.uml.UMLNode;

public class Type
extends UMLNode {
    private Namespace packageNamespace;
    private Classification classfication;
    private TypeName name;
    private boolean isDeprecated;
    private boolean includePackagename;
    private Link link;

    public Type(Namespace namespace, Classification classification, TypeName name) {
        this(namespace, classification, name, false, false, null);
    }

    private Type(Namespace namespace, Classification classification, TypeName name, boolean isDeprecated, boolean addPackageToName, Collection<? extends UMLNode> children) {
        super(namespace);
        this.packageNamespace = Objects.requireNonNull(namespace, "Containing package is <null>.");
        this.classfication = Objects.requireNonNull(classification, "Type classification is <null>.");
        this.name = Objects.requireNonNull(name, "Type name is <null>.");
        this.isDeprecated = isDeprecated;
        this.includePackagename = addPackageToName;
        if (children != null) {
            children.forEach(this::addChild);
        }
    }

    public TypeName getName() {
        return this.name;
    }

    public void updateGenericTypeVariables(TypeName name) {
        if (name != null && name.qualified.equals(this.name.qualified)) {
            TypeName[] generics = this.name.getGenerics();
            this.name = name;
            if (generics.length == name.getGenerics().length) {
                this.getChildren().stream().filter(TypeMember.class::isInstance).map(TypeMember.class::cast).forEach(member -> {
                    for (int i = 0; i < generics.length; ++i) {
                        member.replaceParameterizedType(generics[i], name.getGenerics()[i]);
                    }
                });
            }
        }
    }

    private Link link() {
        if (this.link == null) {
            this.link = Link.forType(this);
        }
        return this.link;
    }

    public Type deprecated() {
        this.isDeprecated = true;
        return this;
    }

    public void setIncludePackagename(boolean include) {
        this.includePackagename = include;
    }

    public Optional<String> getModulename() {
        return this.packageNamespace.getModuleName();
    }

    public String getPackagename() {
        return this.packageNamespace.name;
    }

    public Classification getClassfication() {
        return this.classfication;
    }

    private <IPW extends IndentingPrintWriter> IPW writeNameTo(IPW output) {
        if (this.includePackagename && this.name.qualified.startsWith(this.packageNamespace.name + ".")) {
            String nameInPackage = this.name.qualified.substring(this.packageNamespace.name.length() + 1);
            output.append("\"<size:14>").append(nameInPackage).append("\\n<size:10>").append(this.packageNamespace.name).append("\" as ");
        }
        Namespace namespace = this.findParent(Namespace.class).orElse(null);
        output.append(this.name.toUml(TypeDisplay.QUALIFIED, namespace));
        return output;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeTo(IPW output) {
        output.append(this.classfication.toUml()).whitespace();
        this.writeNameTo(output).whitespace();
        if (this.isDeprecated) {
            output.append("<<deprecated>>").whitespace();
        }
        this.link().writeTo(output).whitespace();
        this.writeChildrenTo(output);
        output.newline();
        return output;
    }

    @Override
    public <IPW extends IndentingPrintWriter> IPW writeChildrenTo(IPW output) {
        if (!this.getChildren().isEmpty() && !Classification.ANNOTATION.equals((Object)this.classfication)) {
            output.append('{').newline();
            super.writeChildrenTo(output.indent());
            output.append('}');
        }
        return output;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object other) {
        return this == other || other instanceof Type && this.name.equals(((Type)other).name);
    }

    public static enum Classification {
        ENUM,
        INTERFACE,
        ANNOTATION,
        ABSTRACT_CLASS,
        CLASS;


        public String toUml() {
            return this.name().toLowerCase(Locale.ENGLISH).replace('_', ' ');
        }
    }
}

