/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.code;

public enum DigestMethod {
    SHA1("SHA-1", "http://www.w3.org/2000/09/xmldsig#sha1"),
    SHA256("SHA-256", "http://www.w3.org/2001/04/xmlenc#sha256"),
    SHA512("SHA-512", "http://www.w3.org/2001/04/xmlenc#sha512");

    private final String identifier;
    private final String uri;

    private DigestMethod(String identifier, String uri) {
        this.identifier = identifier;
        this.uri = uri;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getUri() {
        return this.uri;
    }

    public static DigestMethod fromUri(String uri) {
        for (DigestMethod digestMethod : DigestMethod.values()) {
            if (!digestMethod.uri.equals(uri)) continue;
            return digestMethod;
        }
        return null;
    }
}

