/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import no.difi.vefa.peppol.common.model.ArgumentIdentifier;
import no.difi.vefa.peppol.common.model.DocumentTypeIdentifier;
import no.difi.vefa.peppol.common.model.InstanceIdentifier;
import no.difi.vefa.peppol.common.model.InstanceType;
import no.difi.vefa.peppol.common.model.ParticipantIdentifier;
import no.difi.vefa.peppol.common.model.ProcessIdentifier;

public class Header
implements Serializable {
    private static final long serialVersionUID = -7517561747468194479L;
    private ParticipantIdentifier sender;
    private ParticipantIdentifier receiver;
    private ProcessIdentifier process;
    private DocumentTypeIdentifier documentType;
    private InstanceIdentifier identifier;
    private InstanceType instanceType;
    private Date creationTimestamp;
    private Map<String, ArgumentIdentifier> arguments = new HashMap<String, ArgumentIdentifier>();

    public static Header newInstance() {
        return new Header();
    }

    public static Header of(ParticipantIdentifier sender, ParticipantIdentifier receiver, ProcessIdentifier process, DocumentTypeIdentifier documentType, InstanceIdentifier identifier, InstanceType instanceType, Date creationTimestamp) {
        return new Header(sender, receiver, process, documentType, identifier, instanceType, creationTimestamp, null);
    }

    public static Header of(ParticipantIdentifier sender, ParticipantIdentifier receiver, ProcessIdentifier process, DocumentTypeIdentifier documentType) {
        return new Header(sender, receiver, process, documentType, null, null, null, null);
    }

    public Header() {
    }

    private Header(ParticipantIdentifier sender, ParticipantIdentifier receiver, ProcessIdentifier process, DocumentTypeIdentifier documentType, InstanceIdentifier identifier, InstanceType instanceType, Date creationTimestamp, Map<String, ArgumentIdentifier> arguments) {
        this.sender = sender;
        this.receiver = receiver;
        this.process = process;
        this.documentType = documentType;
        this.identifier = identifier;
        this.instanceType = instanceType;
        this.creationTimestamp = creationTimestamp;
        this.arguments = arguments == null ? this.arguments : arguments;
    }

    public Header sender(ParticipantIdentifier sender) {
        return this.copy(h -> {
            h.sender = sender;
        });
    }

    public Header receiver(ParticipantIdentifier receiver) {
        return this.copy(h -> {
            h.receiver = receiver;
        });
    }

    public Header process(ProcessIdentifier process) {
        return this.copy(h -> {
            h.process = process;
        });
    }

    public Header documentType(DocumentTypeIdentifier documentType) {
        return this.copy(h -> {
            h.documentType = documentType;
        });
    }

    public Header identifier(InstanceIdentifier identifier) {
        return this.copy(h -> {
            h.identifier = identifier;
        });
    }

    public Header instanceType(InstanceType instanceType) {
        return this.copy(h -> {
            h.instanceType = instanceType;
        });
    }

    public Header creationTimestamp(Date creationTimestamp) {
        return this.copy(h -> {
            h.creationTimestamp = creationTimestamp;
        });
    }

    public Header argument(ArgumentIdentifier identifier) {
        return this.copy(h -> h.arguments.put(identifier.getKey(), identifier));
    }

    public Header arguments(List<ArgumentIdentifier> extras) {
        return this.copy(h -> extras.forEach(ai -> h.arguments.put(ai.getKey(), (ArgumentIdentifier)ai)));
    }

    public ArgumentIdentifier getArgument(String key) {
        return this.arguments.get(key);
    }

    public List<ArgumentIdentifier> getArguments() {
        return new ArrayList<ArgumentIdentifier>(this.arguments.values());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Header header = (Header)o;
        return Objects.equals(this.sender, header.sender) && Objects.equals(this.receiver, header.receiver) && Objects.equals(this.process, header.process) && Objects.equals(this.documentType, header.documentType) && Objects.equals(this.identifier, header.identifier) && Objects.equals(this.instanceType, header.instanceType) && Objects.equals(this.creationTimestamp, header.creationTimestamp) && Objects.equals(this.arguments, header.arguments);
    }

    public int hashCode() {
        return Objects.hash(this.sender, this.receiver, this.process, this.documentType, this.identifier, this.instanceType, this.creationTimestamp, this.arguments);
    }

    public String toString() {
        return "Header{sender=" + this.sender + ", receiver=" + this.receiver + ", process=" + this.process + ", documentType=" + this.documentType + ", identifier=" + this.identifier + ", instanceType=" + this.instanceType + ", creationTimestamp=" + this.creationTimestamp + ", arguments=" + this.arguments + '}';
    }

    private Header copy(Consumer<Header> consumer) {
        Header header = new Header(this.sender, this.receiver, this.process, this.documentType, this.identifier, this.instanceType, this.creationTimestamp, new HashMap<String, ArgumentIdentifier>(this.arguments));
        consumer.accept(header);
        return header;
    }

    public ParticipantIdentifier getSender() {
        return this.sender;
    }

    public ParticipantIdentifier getReceiver() {
        return this.receiver;
    }

    public ProcessIdentifier getProcess() {
        return this.process;
    }

    public DocumentTypeIdentifier getDocumentType() {
        return this.documentType;
    }

    public InstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    public InstanceType getInstanceType() {
        return this.instanceType;
    }

    public Date getCreationTimestamp() {
        return this.creationTimestamp;
    }
}

