/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.model;

import java.io.Serializable;
import java.util.Locale;
import no.difi.vefa.peppol.common.lang.PeppolParsingException;
import no.difi.vefa.peppol.common.model.AbstractQualifiedIdentifier;
import no.difi.vefa.peppol.common.model.Scheme;

public class ParticipantIdentifier
extends AbstractQualifiedIdentifier
implements Serializable {
    private static final long serialVersionUID = -8052874032415088055L;
    public static final Scheme DEFAULT_SCHEME = Scheme.of("iso6523-actorid-upis");

    public static ParticipantIdentifier of(String value) {
        return ParticipantIdentifier.of(value, DEFAULT_SCHEME);
    }

    public static ParticipantIdentifier of(String value, Scheme scheme) {
        return new ParticipantIdentifier(value, scheme);
    }

    public static ParticipantIdentifier parse(String str) throws PeppolParsingException {
        String[] parts = str.split("::", 2);
        if (parts.length != 2) {
            throw new PeppolParsingException(String.format("Unable to parse participant identifier '%s'.", str));
        }
        return ParticipantIdentifier.of(parts[1], Scheme.of(parts[0]));
    }

    private ParticipantIdentifier(String identifier, Scheme scheme) {
        super(identifier.trim().toLowerCase(Locale.US), scheme);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ParticipantIdentifier that = (ParticipantIdentifier)o;
        if (!this.scheme.equals(that.scheme)) {
            return false;
        }
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        int result = this.scheme.hashCode();
        result = 31 * result + this.identifier.hashCode();
        return result;
    }

    public String toString() {
        return String.format("%s::%s", this.scheme, this.identifier);
    }
}

