/*
 * Decompiled with CFR 0.152.
 */
package no.difi.vefa.peppol.common.util;

import no.difi.vefa.peppol.common.api.PerformAction;
import no.difi.vefa.peppol.common.api.PerformResult;
import no.difi.vefa.peppol.common.lang.PeppolRuntimeException;

public class ExceptionUtil {
    public static <E extends Exception> void perform(Class<E> cls, PerformAction action) throws E {
        try {
            action.action();
        }
        catch (Exception e) {
            throw ExceptionUtil.prepareException(cls, e.getMessage(), e);
        }
    }

    public static <T, E extends Exception> T perform(Class<E> cls, PerformResult<T> action) throws E {
        try {
            return action.action();
        }
        catch (Exception e) {
            throw ExceptionUtil.prepareException(cls, e.getMessage(), e);
        }
    }

    public static <T, E extends Exception> T perform(Class<E> cls, String message, PerformResult<T> action) throws E {
        try {
            return action.action();
        }
        catch (Exception e) {
            throw ExceptionUtil.prepareException(cls, message, e);
        }
    }

    private static <E extends Exception> E prepareException(Class<E> cls, String message, Throwable throwable) throws E {
        try {
            return (E)((Exception)cls.getConstructor(String.class, Throwable.class).newInstance(message, throwable));
        }
        catch (Exception e) {
            throw new PeppolRuntimeException(String.format("Unable to initiate exception '%s'.", cls), e);
        }
    }
}

