/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.Unleash;
import no.finn.unleash.repository.FeatureToggleRepository;
import no.finn.unleash.repository.HttpToggleFetcher;
import no.finn.unleash.repository.ToggleBackupHandlerFile;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.strategy.DefaultStrategy;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.UnknownStrategy;

public final class DefaultUnleash
implements Unleash {
    private static final DefaultStrategy DEFAULT_STRATEGY = new DefaultStrategy();
    private static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private final ToggleRepository toggleRepository;
    private final Map<String, Strategy> strategyMap;

    public DefaultUnleash(URI unleashServer, Strategy ... strategies) {
        this(new FeatureToggleRepository(new HttpToggleFetcher(unleashServer), new ToggleBackupHandlerFile()), strategies);
    }

    public DefaultUnleash(ToggleRepository toggleRepository, Strategy ... strategies) {
        this.toggleRepository = toggleRepository;
        this.strategyMap = this.buildStrategyMap(strategies);
    }

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        if (featureToggle == null) {
            return defaultSetting;
        }
        Strategy strategy = this.getStrategy(featureToggle.getStrategy());
        return featureToggle.isEnabled() && strategy.isEnabled(featureToggle.getParameters());
    }

    private Map<String, Strategy> buildStrategyMap(Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        map.put(DEFAULT_STRATEGY.getName(), DEFAULT_STRATEGY);
        if (strategies != null) {
            for (Strategy strategy : strategies) {
                map.put(strategy.getName(), strategy);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        if (this.strategyMap.containsKey(strategy)) {
            return this.strategyMap.get(strategy);
        }
        return UNKNOWN_STRATEGY;
    }
}

