/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.UnleashException;
import no.finn.unleash.repository.Response;
import no.finn.unleash.repository.ToggleBackupHandler;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.repository.ToggleFetcher;
import no.finn.unleash.repository.ToggleRepository;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class FeatureToggleRepository
implements ToggleRepository {
    private static final Logger LOG = LogManager.getLogger();
    private static final ScheduledThreadPoolExecutor TIMER = new ScheduledThreadPoolExecutor(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setName("unleash-toggle-repository");
            thread.setDaemon(true);
            return thread;
        }
    });
    private final ToggleBackupHandler toggleBackupHandler;
    private final ToggleFetcher toggleFetcher;
    private ToggleCollection toggleCollection;

    public FeatureToggleRepository(ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler) {
        this(toggleFetcher, toggleBackupHandler, 10L);
    }

    public FeatureToggleRepository(ToggleFetcher toggleFetcher, ToggleBackupHandler toggleBackupHandler, long pollIntervalSeconds) {
        this.toggleBackupHandler = toggleBackupHandler;
        this.toggleFetcher = toggleFetcher;
        this.toggleCollection = toggleBackupHandler.read();
        this.startBackgroundPolling(pollIntervalSeconds);
    }

    private ScheduledFuture startBackgroundPolling(long pollIntervalSeconds) {
        try {
            return TIMER.scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    try {
                        Response response = FeatureToggleRepository.this.toggleFetcher.fetchToggles();
                        if (response.getStatus() == Response.Status.CHANGED) {
                            FeatureToggleRepository.this.toggleCollection = response.getToggleCollection();
                            FeatureToggleRepository.this.toggleBackupHandler.write(response.getToggleCollection());
                        }
                    }
                    catch (UnleashException e) {
                        LOG.warn("Could not refresh feature toggles", (Throwable)e);
                    }
                }
            }, 0L, pollIntervalSeconds, TimeUnit.SECONDS);
        }
        catch (RejectedExecutionException ex) {
            LOG.error("Unleash background task crashed", (Throwable)ex);
            return null;
        }
    }

    @Override
    public FeatureToggle getToggle(String name) {
        return this.toggleCollection.getToggle(name);
    }

    static {
        TIMER.setRemoveOnCancelPolicy(true);
    }
}

