/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import no.finn.unleash.UnleashException;
import no.finn.unleash.repository.JsonToggleParser;
import no.finn.unleash.repository.Response;
import no.finn.unleash.repository.ToggleCollection;
import no.finn.unleash.repository.ToggleFetcher;

public final class HttpToggleFetcher
implements ToggleFetcher {
    public static final int CONNECT_TIMEOUT = 10000;
    private String etag = "";
    private final URL toggleUrl;

    public HttpToggleFetcher(URI repo) {
        try {
            this.toggleUrl = repo.toURL();
        }
        catch (IllegalArgumentException | MalformedURLException ex) {
            throw new UnleashException("Invalid unleash repository uri [" + repo.toString() + "]", ex);
        }
    }

    @Override
    public Response fetchToggles() throws UnleashException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)this.toggleUrl.openConnection();
            connection.setConnectTimeout(10000);
            connection.setReadTimeout(10000);
            connection.setRequestProperty("Accept", "application/json");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("If-None-Match", this.etag);
            connection.setUseCaches(true);
            connection.connect();
            int responseCode = connection.getResponseCode();
            if (responseCode < 300) {
                Response response = this.getToggleResponse(connection);
                return response;
            }
            Response response = new Response(Response.Status.NOT_CHANGED);
            return response;
        }
        catch (IOException e) {
            throw new UnleashException("Could not fetch toggles", e);
        }
        catch (IllegalStateException e) {
            throw new UnleashException(e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private Response getToggleResponse(HttpURLConnection request) throws IOException {
        this.etag = request.getHeaderField("ETag");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)request.getContent(), StandardCharsets.UTF_8));){
            ToggleCollection toggles = JsonToggleParser.fromJson(reader);
            Response response = new Response(Response.Status.CHANGED, toggles);
            return response;
        }
    }
}

