/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash.repository;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.repository.JsonToggleParser;
import no.finn.unleash.repository.ToggleBackupHandler;
import no.finn.unleash.repository.ToggleCollection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ToggleBackupHandlerFile
implements ToggleBackupHandler {
    private static final Logger LOG = LogManager.getLogger();
    private final String backupFile;

    public ToggleBackupHandlerFile() {
        this(System.getProperty("java.io.tmpdir") + File.separatorChar + "unleash-repo.json");
    }

    public ToggleBackupHandlerFile(String backupFile) {
        this.backupFile = backupFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public ToggleCollection read() {
        LOG.info("Unleash will try to load feature toggle states from temporary backup");
        try (FileReader reader = new FileReader(this.backupFile);){
            BufferedReader br = new BufferedReader(reader);
            ToggleCollection toggleCollection = JsonToggleParser.fromJson(br);
            return toggleCollection;
        }
        catch (FileNotFoundException e) {
            LOG.warn(" Unleash could not find the backup-file '" + this.backupFile + "'. \n" + "This is expected behavior the first time unleash runs in a new environment.");
        }
        catch (IOException e) {
            LOG.error("Failed to read backup file:'{}'", new Object[]{this.backupFile, e});
        }
        List<FeatureToggle> emptyList = Collections.emptyList();
        return new ToggleCollection(emptyList);
    }

    @Override
    public void write(ToggleCollection toggleCollection) {
        try (FileWriter writer = new FileWriter(this.backupFile);){
            writer.write(JsonToggleParser.toJsonString(toggleCollection));
        }
        catch (IOException e) {
            LOG.warn("Unleash was unable to backup feature toggles to file: {}", new Object[]{this.backupFile, e});
        }
    }
}

