/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import no.finn.unleash.FeatureToggle;
import no.finn.unleash.Unleash;
import no.finn.unleash.UnleashContext;
import no.finn.unleash.UnleashContextProvider;
import no.finn.unleash.metric.UnleashMetricService;
import no.finn.unleash.metric.UnleashMetricServiceImpl;
import no.finn.unleash.repository.FeatureToggleRepository;
import no.finn.unleash.repository.HttpToggleFetcher;
import no.finn.unleash.repository.ToggleBackupHandlerFile;
import no.finn.unleash.repository.ToggleRepository;
import no.finn.unleash.strategy.ApplicationHostnameStrategy;
import no.finn.unleash.strategy.DefaultStrategy;
import no.finn.unleash.strategy.GradualRolloutRandomStrategy;
import no.finn.unleash.strategy.GradualRolloutSessionIdStrategy;
import no.finn.unleash.strategy.GradualRolloutUserIdStrategy;
import no.finn.unleash.strategy.RemoteAddressStrategy;
import no.finn.unleash.strategy.Strategy;
import no.finn.unleash.strategy.UnknownStrategy;
import no.finn.unleash.strategy.UserWithIdStrategy;
import no.finn.unleash.util.UnleashConfig;
import no.finn.unleash.util.UnleashScheduledExecutor;
import no.finn.unleash.util.UnleashScheduledExecutorImpl;

public final class DefaultUnleash
implements Unleash {
    private static final List<Strategy> BUILTIN_STRATEGIES = Arrays.asList(new DefaultStrategy(), new ApplicationHostnameStrategy(), new GradualRolloutRandomStrategy(), new GradualRolloutSessionIdStrategy(), new GradualRolloutUserIdStrategy(), new RemoteAddressStrategy(), new UserWithIdStrategy());
    private static final UnknownStrategy UNKNOWN_STRATEGY = new UnknownStrategy();
    private static final UnleashScheduledExecutor unleashScheduledExecutor = new UnleashScheduledExecutorImpl();
    private final UnleashMetricService metricService;
    private final ToggleRepository toggleRepository;
    private final Map<String, Strategy> strategyMap;
    private final UnleashContextProvider contextProvider;

    private static FeatureToggleRepository defaultToggleRepository(UnleashConfig unleashConfig) {
        return new FeatureToggleRepository(unleashConfig, unleashScheduledExecutor, new HttpToggleFetcher(unleashConfig), new ToggleBackupHandlerFile(unleashConfig));
    }

    public DefaultUnleash(UnleashConfig unleashConfig, Strategy ... strategies) {
        this(unleashConfig, DefaultUnleash.defaultToggleRepository(unleashConfig), strategies);
    }

    public DefaultUnleash(UnleashConfig unleashConfig, ToggleRepository toggleRepository, Strategy ... strategies) {
        this.toggleRepository = toggleRepository;
        this.strategyMap = this.buildStrategyMap(strategies);
        this.contextProvider = unleashConfig.getContextProvider();
        this.metricService = new UnleashMetricServiceImpl(unleashConfig, unleashScheduledExecutor);
        this.metricService.register(this.strategyMap.keySet());
    }

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        return this.isEnabled(toggleName, this.contextProvider.getContext(), defaultSetting);
    }

    @Override
    public boolean isEnabled(String toggleName, UnleashContext context, boolean defaultSetting) {
        boolean enabled = false;
        FeatureToggle featureToggle = this.toggleRepository.getToggle(toggleName);
        enabled = featureToggle == null ? defaultSetting : (!featureToggle.isEnabled() ? false : featureToggle.getStrategies().stream().filter(as -> this.getStrategy(as.getName()).isEnabled(as.getParameters(), context)).findFirst().isPresent());
        this.metricService.count(toggleName, enabled);
        return enabled;
    }

    private Map<String, Strategy> buildStrategyMap(Strategy[] strategies) {
        HashMap<String, Strategy> map = new HashMap<String, Strategy>();
        BUILTIN_STRATEGIES.forEach(strategy -> map.put(strategy.getName(), (Strategy)strategy));
        if (strategies != null) {
            for (Strategy strategy2 : strategies) {
                map.put(strategy2.getName(), strategy2);
            }
        }
        return map;
    }

    private Strategy getStrategy(String strategy) {
        return this.strategyMap.containsKey(strategy) ? this.strategyMap.get(strategy) : UNKNOWN_STRATEGY;
    }
}

