/*
 * Decompiled with CFR 0.152.
 */
package no.finn.unleash;

import java.util.HashMap;
import java.util.Map;
import no.finn.unleash.Unleash;

public final class FakeUnleash
implements Unleash {
    private boolean enableAll = false;
    private boolean disableAll = false;
    private Map<String, Boolean> features = new HashMap<String, Boolean>();

    @Override
    public boolean isEnabled(String toggleName) {
        return this.isEnabled(toggleName, false);
    }

    @Override
    public boolean isEnabled(String toggleName, boolean defaultSetting) {
        if (this.enableAll) {
            return true;
        }
        if (this.disableAll) {
            return false;
        }
        return this.features.getOrDefault(toggleName, defaultSetting);
    }

    public void enableAll() {
        this.disableAll = false;
        this.enableAll = true;
        this.features.clear();
    }

    public void disableAll() {
        this.disableAll = true;
        this.enableAll = false;
        this.features.clear();
    }

    public void resetAll() {
        this.disableAll = false;
        this.enableAll = false;
        this.features.clear();
    }

    public void enable(String ... features) {
        for (String name : features) {
            this.features.put(name, true);
        }
    }

    public void disable(String ... features) {
        for (String name : features) {
            this.features.put(name, false);
        }
    }

    public void reset(String ... features) {
        for (String name : features) {
            this.features.remove(name);
        }
    }
}

